#define DSP_VERSION "#VERSION=1.3"

//CONTROL LOCATIONS

typedef struct {
u8 control_page;           //coefficient page location
u8 control_base;           //coefficient base address within page
u8 control_mute_flag;      //non-zero means muting required
u8 control_string_index;   //string table index
} first_control;

static first_control MUX_first_controls[] = {
};

static string MUX_first_control_names[] = {
};

static first_control VOLUME_first_controls[] = {
};

static string VOLUME_first_control_names[] = {
};

//INSTRUCTIONS & COEFFICIENTS
typedef struct {
u8 reg_off;
u8 reg_val;
} first_reg_value;

static string REG_first_Section_names[] = {
"miniDSP_A_reg_values",
"miniDSP_D_reg_values",
};

first_reg_value REG_first_Section_program[] = {
};

#if 1 //For debugging Need to delete in final release
first_reg_value REG_first_Section_init_program[] = {
};

first_reg_value REG_first_Section_post_program[] = {
};

#endif

first_reg_value miniDSP_A_first_reg_values[] = {
};

first_reg_value miniDSP_D_first_reg_values_p1[] = {
  {    0, 0x00 }, 
  {    1, 0x01 }, 
  {   21, 0x03 }, 
  {   22, 0x88 }, 
  {    0, 0x08 }, 
  {    8, 0xFF }, 
  {    9, 0xFF }, 
  {   10, 0xFF }, 
  {   11, 0x00 }, 
  {   12, 0x50 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x80 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x40 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x7F }, 
  {   29, 0xFF }, 
  {   30, 0xFF }, 
  {   31, 0x00 }, 
  {   32, 0x01 }, 
  {   33, 0x17 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x01 }, 
  {   37, 0x17 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x79 }, 
  {   41, 0x15 }, 
  {   42, 0x85 }, 
  {   43, 0x00 }, 
  {   44, 0x86 }, 
  {   45, 0xEA }, 
  {   46, 0x7B }, 
  {   47, 0x00 }, 
  {   48, 0x79 }, 
  {   49, 0x15 }, 
  {   50, 0x85 }, 
  {   51, 0x00 }, 
  {   52, 0x78 }, 
  {   53, 0xE5 }, 
  {   54, 0xAB }, 
  {   55, 0x00 }, 
  {   56, 0x8D }, 
  {   57, 0x75 }, 
  {   58, 0x41 }, 
  {   59, 0x00 }, 
  {   60, 0x79 }, 
  {   61, 0x15 }, 
  {   62, 0x85 }, 
  {   63, 0x00 }, 
  {   64, 0x86 }, 
  {   65, 0xEA }, 
  {   66, 0x7B }, 
  {   67, 0x00 }, 
  {   68, 0x79 }, 
  {   69, 0x15 }, 
  {   70, 0x85 }, 
  {   71, 0x00 }, 
  {   72, 0x78 }, 
  {   73, 0xE5 }, 
  {   74, 0xAB }, 
  {   75, 0x00 }, 
  {   76, 0x8D }, 
  {   77, 0x75 }, 
  {   78, 0x41 }, 
  {   79, 0x00 }, 
  {   80, 0x7B }, 
  {   81, 0xCD }, 
  {   82, 0xF2 }, 
  {   83, 0x00 }, 
  {   84, 0x84 }, 
  {   85, 0x32 }, 
  {   86, 0x0E }, 
  {   87, 0x00 }, 
  {   88, 0x7B }, 
  {   89, 0xCD }, 
  {   90, 0xF2 }, 
  {   91, 0x00 }, 
  {   92, 0x7B }, 
  {   93, 0xBC }, 
  {   94, 0x57 }, 
  {   95, 0x00 }, 
  {   96, 0x88 }, 
  {   97, 0x40 }, 
  {   98, 0xE7 }, 
  {   99, 0x00 }, 
  {  100, 0x48 }, 
  {  101, 0x19 }, 
  {  102, 0x97 }, 
  {  103, 0x00 }, 
  {  104, 0x03 }, 
  {  105, 0x0F }, 
  {  106, 0x8A }, 
  {  107, 0x00 }, 
  {  108, 0x0C }, 
  {  109, 0x76 }, 
  {  110, 0x58 }, 
  {  111, 0x00 }, 
  {  112, 0x20 }, 
  {  113, 0x99 }, 
  {  114, 0x21 }, 
  {  115, 0x00 }, 
  {  116, 0xE4 }, 
  {  117, 0x1E }, 
  {  118, 0xB7 }, 
  {  119, 0x00 }, 
  {  120, 0x1F }, 
  {  121, 0xC9 }, 
  {  122, 0x22 }, 
  {  123, 0x00 }, 
  {  124, 0x1F }, 
  {  125, 0xC9 }, 
  {  126, 0x22 }, 
  {  127, 0x00 }, 
  {    0, 0x09 }, 
  {    8, 0x1F }, 
  {    9, 0xC9 }, 
  {   10, 0x22 }, 
  {   11, 0x00 }, 
  {   12, 0x0B }, 
  {   13, 0xC9 }, 
  {   14, 0xF8 }, 
  {   15, 0x00 }, 
  {   16, 0xE9 }, 
  {   17, 0x47 }, 
  {   18, 0x85 }, 
  {   19, 0x00 }, 
  {   20, 0x72 }, 
  {   21, 0x8A }, 
  {   22, 0x48 }, 
  {   23, 0x00 }, 
  {   24, 0x8D }, 
  {   25, 0x75 }, 
  {   26, 0xB8 }, 
  {   27, 0x00 }, 
  {   28, 0x72 }, 
  {   29, 0x8A }, 
  {   30, 0x48 }, 
  {   31, 0x00 }, 
  {   32, 0x71 }, 
  {   33, 0xD4 }, 
  {   34, 0xA9 }, 
  {   35, 0x00 }, 
  {   36, 0x99 }, 
  {   37, 0x80 }, 
  {   38, 0x31 }, 
  {   39, 0x00 }, 
  {   40, 0x71 }, 
  {   41, 0x46 }, 
  {   42, 0x20 }, 
  {   43, 0x00 }, 
  {   44, 0x8E }, 
  {   45, 0xB9 }, 
  {   46, 0xE0 }, 
  {   47, 0x00 }, 
  {   48, 0x71 }, 
  {   49, 0x46 }, 
  {   50, 0x20 }, 
  {   51, 0x00 }, 
  {   52, 0x70 }, 
  {   53, 0x6C }, 
  {   54, 0x9B }, 
  {   55, 0x00 }, 
  {   56, 0x9B }, 
  {   57, 0xC0 }, 
  {   58, 0xB4 }, 
  {   59, 0x00 }, 
  {   60, 0x22 }, 
  {   61, 0x97 }, 
  {   62, 0x44 }, 
  {   63, 0x00 }, 
  {   64, 0x22 }, 
  {   65, 0x97 }, 
  {   66, 0x44 }, 
  {   67, 0x00 }, 
  {   68, 0x22 }, 
  {   69, 0x97 }, 
  {   70, 0x44 }, 
  {   71, 0x00 }, 
  {   72, 0x05 }, 
  {   73, 0xE3 }, 
  {   74, 0xDB }, 
  {   75, 0x00 }, 
  {   76, 0xE9 }, 
  {   77, 0xDB }, 
  {   78, 0x38 }, 
  {   79, 0x00 }, 
  {   80, 0x5A }, 
  {   81, 0xA6 }, 
  {   82, 0x4F }, 
  {   83, 0x00 }, 
  {   84, 0x09 }, 
  {   85, 0x3A }, 
  {   86, 0xC7 }, 
  {   87, 0x00 }, 
  {   88, 0x10 }, 
  {   89, 0x37 }, 
  {   90, 0xE7 }, 
  {   91, 0x00 }, 
  {   92, 0x0C }, 
  {   93, 0xC4 }, 
  {   94, 0x93 }, 
  {   95, 0x00 }, 
  {   96, 0xE9 }, 
  {   97, 0x23 }, 
  {   98, 0x12 }, 
  {   99, 0x00 }, 
  {  100, 0x7B }, 
  {  101, 0xCD }, 
  {  102, 0xF2 }, 
  {  103, 0x00 }, 
  {  104, 0x84 }, 
  {  105, 0x32 }, 
  {  106, 0x0E }, 
  {  107, 0x00 }, 
  {  108, 0x7B }, 
  {  109, 0xCD }, 
  {  110, 0xF2 }, 
  {  111, 0x00 }, 
  {  112, 0x7B }, 
  {  113, 0xBC }, 
  {  114, 0x57 }, 
  {  115, 0x00 }, 
  {  116, 0x88 }, 
  {  117, 0x40 }, 
  {  118, 0xE7 }, 
  {  119, 0x00 }, 
  {  120, 0x7F }, 
  {  121, 0xFF }, 
  {  122, 0xFF }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x0A }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x7D }, 
  {   21, 0xD3 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x7B }, 
  {   25, 0x29 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x84 }, 
  {   29, 0xD7 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x89 }, 
  {   33, 0xAE }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0xFF }, 
  {   37, 0x9E }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x01 }, 
  {   43, 0x00 }, 
  {   44, 0x66 }, 
  {   45, 0x66 }, 
  {   46, 0x66 }, 
  {   47, 0x00 }, 
  {   48, 0xF7 }, 
  {   49, 0x10 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x26 }, 
  {   53, 0xF0 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x40 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x02 }, 
  {   65, 0x61 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x40 }, 
  {   69, 0x02 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0xFF }, 
  {   73, 0xFC }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0xFF }, 
  {   77, 0xFD }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0xFF }, 
  {   81, 0xE5 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0xFF }, 
  {   85, 0xA7 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0xFF }, 
  {   89, 0xC7 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0xFF }, 
  {   93, 0xCE }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0xFF }, 
  {   97, 0xFE }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0xFE }, 
  {  101, 0xF7 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0xFF }, 
  {  105, 0x46 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0xFF }, 
  {  109, 0x22 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0xFF }, 
  {  113, 0x0F }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0xFA }, 
  {  117, 0x8C }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0xF5 }, 
  {  121, 0x08 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0xFD }, 
  {  125, 0x92 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x0B }, 
  {    8, 0xF3 }, 
  {    9, 0xA3 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x03 }, 
  {   13, 0xB3 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x33 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x71 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x40 }, 
  {   25, 0x60 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0xE2 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0xC6 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x87 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x0F }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x0A }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x02 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x01 }, 
  {   53, 0x81 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x18 }, 
  {   57, 0x89 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x07 }, 
  {   61, 0xFB }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x03 }, 
  {   65, 0xBE }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x20 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x01 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x80 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x04 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x01 }, 
  {   87, 0x00 }, 
  {   88, 0xC0 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0xFF }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0xFF }, 
  {   97, 0x80 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x7C }, 
  {  102, 0x4D }, 
  {  103, 0x00 }, 
  {  104, 0x3E }, 
  {  105, 0x26 }, 
  {  106, 0x80 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x36 }, 
  {  110, 0x19 }, 
  {  111, 0x00 }, 
  {  112, 0x7C }, 
  {  113, 0x4D }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x36 }, 
  {  117, 0x19 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x01 }, 
  {  121, 0x90 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x7F }, 
  {  125, 0x33 }, 
  {  126, 0xD7 }, 
  {  127, 0x00 }, 
  {    0, 0x0C }, 
  {    8, 0x00 }, 
  {    9, 0xCC }, 
  {   10, 0x29 }, 
  {   11, 0x00 }, 
  {   12, 0xD8 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0xC1 }, 
  {   17, 0x80 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x25 }, 
  {   21, 0xC5 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x55 }, 
  {   26, 0x55 }, 
  {   27, 0x00 }, 
  {   28, 0x21 }, 
  {   29, 0x3F }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x6A }, 
  {   33, 0x6E }, 
  {   34, 0x51 }, 
  {   35, 0x00 }, 
  {   36, 0x98 }, 
  {   37, 0x51 }, 
  {   38, 0xEC }, 
  {   39, 0x00 }, 
  {   40, 0x01 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0xFF }, 
  {   45, 0xFC }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0xC0 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x48 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x6D }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x6A }, 
  {   71, 0x00 }, 
  {    0, 0x1A }, 
  {    8, 0xFF }, 
  {    9, 0xFF }, 
  {   10, 0xFF }, 
  {   11, 0x00 }, 
  {   12, 0x50 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x80 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x40 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x7F }, 
  {   29, 0xFF }, 
  {   30, 0xFF }, 
  {   31, 0x00 }, 
  {   32, 0x01 }, 
  {   33, 0x17 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x01 }, 
  {   37, 0x17 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x79 }, 
  {   41, 0x15 }, 
  {   42, 0x85 }, 
  {   43, 0x00 }, 
  {   44, 0x86 }, 
  {   45, 0xEA }, 
  {   46, 0x7B }, 
  {   47, 0x00 }, 
  {   48, 0x79 }, 
  {   49, 0x15 }, 
  {   50, 0x85 }, 
  {   51, 0x00 }, 
  {   52, 0x78 }, 
  {   53, 0xE5 }, 
  {   54, 0xAB }, 
  {   55, 0x00 }, 
  {   56, 0x8D }, 
  {   57, 0x75 }, 
  {   58, 0x41 }, 
  {   59, 0x00 }, 
  {   60, 0x79 }, 
  {   61, 0x15 }, 
  {   62, 0x85 }, 
  {   63, 0x00 }, 
  {   64, 0x86 }, 
  {   65, 0xEA }, 
  {   66, 0x7B }, 
  {   67, 0x00 }, 
  {   68, 0x79 }, 
  {   69, 0x15 }, 
  {   70, 0x85 }, 
  {   71, 0x00 }, 
  {   72, 0x78 }, 
  {   73, 0xE5 }, 
  {   74, 0xAB }, 
  {   75, 0x00 }, 
  {   76, 0x8D }, 
  {   77, 0x75 }, 
  {   78, 0x41 }, 
  {   79, 0x00 }, 
  {   80, 0x7B }, 
  {   81, 0xCD }, 
  {   82, 0xF2 }, 
  {   83, 0x00 }, 
  {   84, 0x84 }, 
  {   85, 0x32 }, 
  {   86, 0x0E }, 
  {   87, 0x00 }, 
  {   88, 0x7B }, 
  {   89, 0xCD }, 
  {   90, 0xF2 }, 
  {   91, 0x00 }, 
  {   92, 0x7B }, 
  {   93, 0xBC }, 
  {   94, 0x57 }, 
  {   95, 0x00 }, 
  {   96, 0x88 }, 
  {   97, 0x40 }, 
  {   98, 0xE7 }, 
  {   99, 0x00 }, 
  {  100, 0x48 }, 
  {  101, 0x19 }, 
  {  102, 0x97 }, 
  {  103, 0x00 }, 
  {  104, 0x03 }, 
  {  105, 0x0F }, 
  {  106, 0x8A }, 
  {  107, 0x00 }, 
  {  108, 0x0C }, 
  {  109, 0x76 }, 
  {  110, 0x58 }, 
  {  111, 0x00 }, 
  {  112, 0x20 }, 
  {  113, 0x99 }, 
  {  114, 0x21 }, 
  {  115, 0x00 }, 
  {  116, 0xE4 }, 
  {  117, 0x1E }, 
  {  118, 0xB7 }, 
  {  119, 0x00 }, 
  {  120, 0x1F }, 
  {  121, 0xC9 }, 
  {  122, 0x22 }, 
  {  123, 0x00 }, 
  {  124, 0x1F }, 
  {  125, 0xC9 }, 
  {  126, 0x22 }, 
  {  127, 0x00 }, 
  {    0, 0x1B }, 
  {    8, 0x1F }, 
  {    9, 0xC9 }, 
  {   10, 0x22 }, 
  {   11, 0x00 }, 
  {   12, 0x0B }, 
  {   13, 0xC9 }, 
  {   14, 0xF8 }, 
  {   15, 0x00 }, 
  {   16, 0xE9 }, 
  {   17, 0x47 }, 
  {   18, 0x85 }, 
  {   19, 0x00 }, 
  {   20, 0x72 }, 
  {   21, 0x8A }, 
  {   22, 0x48 }, 
  {   23, 0x00 }, 
  {   24, 0x8D }, 
  {   25, 0x75 }, 
  {   26, 0xB8 }, 
  {   27, 0x00 }, 
  {   28, 0x72 }, 
  {   29, 0x8A }, 
  {   30, 0x48 }, 
  {   31, 0x00 }, 
  {   32, 0x71 }, 
  {   33, 0xD4 }, 
  {   34, 0xA9 }, 
  {   35, 0x00 }, 
  {   36, 0x99 }, 
  {   37, 0x80 }, 
  {   38, 0x31 }, 
  {   39, 0x00 }, 
  {   40, 0x71 }, 
  {   41, 0x46 }, 
  {   42, 0x20 }, 
  {   43, 0x00 }, 
  {   44, 0x8E }, 
  {   45, 0xB9 }, 
  {   46, 0xE0 }, 
  {   47, 0x00 }, 
  {   48, 0x71 }, 
  {   49, 0x46 }, 
  {   50, 0x20 }, 
  {   51, 0x00 }, 
  {   52, 0x70 }, 
  {   53, 0x6C }, 
  {   54, 0x9B }, 
  {   55, 0x00 }, 
  {   56, 0x9B }, 
  {   57, 0xC0 }, 
  {   58, 0xB4 }, 
  {   59, 0x00 }, 
  {   60, 0x22 }, 
  {   61, 0x97 }, 
  {   62, 0x44 }, 
  {   63, 0x00 }, 
  {   64, 0x22 }, 
  {   65, 0x97 }, 
  {   66, 0x44 }, 
  {   67, 0x00 }, 
  {   68, 0x22 }, 
  {   69, 0x97 }, 
  {   70, 0x44 }, 
  {   71, 0x00 }, 
  {   72, 0x05 }, 
  {   73, 0xE3 }, 
  {   74, 0xDB }, 
  {   75, 0x00 }, 
  {   76, 0xE9 }, 
  {   77, 0xDB }, 
  {   78, 0x38 }, 
  {   79, 0x00 }, 
  {   80, 0x5A }, 
  {   81, 0xA6 }, 
  {   82, 0x4F }, 
  {   83, 0x00 }, 
  {   84, 0x09 }, 
  {   85, 0x3A }, 
  {   86, 0xC7 }, 
  {   87, 0x00 }, 
  {   88, 0x10 }, 
  {   89, 0x37 }, 
  {   90, 0xE7 }, 
  {   91, 0x00 }, 
  {   92, 0x0C }, 
  {   93, 0xC4 }, 
  {   94, 0x93 }, 
  {   95, 0x00 }, 
  {   96, 0xE9 }, 
  {   97, 0x23 }, 
  {   98, 0x12 }, 
  {   99, 0x00 }, 
  {  100, 0x7B }, 
  {  101, 0xCD }, 
  {  102, 0xF2 }, 
  {  103, 0x00 }, 
  {  104, 0x84 }, 
  {  105, 0x32 }, 
  {  106, 0x0E }, 
  {  107, 0x00 }, 
  {  108, 0x7B }, 
  {  109, 0xCD }, 
  {  110, 0xF2 }, 
  {  111, 0x00 }, 
  {  112, 0x7B }, 
  {  113, 0xBC }, 
  {  114, 0x57 }, 
  {  115, 0x00 }, 
  {  116, 0x88 }, 
  {  117, 0x40 }, 
  {  118, 0xE7 }, 
  {  119, 0x00 }, 
  {  120, 0x7F }, 
  {  121, 0xFF }, 
  {  122, 0xFF }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x1C }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x7D }, 
  {   21, 0xD3 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x7B }, 
  {   25, 0x29 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x84 }, 
  {   29, 0xD7 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x89 }, 
  {   33, 0xAE }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0xFF }, 
  {   37, 0x9E }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x01 }, 
  {   43, 0x00 }, 
  {   44, 0x66 }, 
  {   45, 0x66 }, 
  {   46, 0x66 }, 
  {   47, 0x00 }, 
  {   48, 0xF7 }, 
  {   49, 0x10 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x26 }, 
  {   53, 0xF0 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x40 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x02 }, 
  {   65, 0x61 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x40 }, 
  {   69, 0x02 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0xFF }, 
  {   73, 0xFC }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0xFF }, 
  {   77, 0xFD }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0xFF }, 
  {   81, 0xE5 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0xFF }, 
  {   85, 0xA7 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0xFF }, 
  {   89, 0xC7 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0xFF }, 
  {   93, 0xCE }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0xFF }, 
  {   97, 0xFE }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0xFE }, 
  {  101, 0xF7 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0xFF }, 
  {  105, 0x46 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0xFF }, 
  {  109, 0x22 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0xFF }, 
  {  113, 0x0F }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0xFA }, 
  {  117, 0x8C }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0xF5 }, 
  {  121, 0x08 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0xFD }, 
  {  125, 0x92 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x1D }, 
  {    8, 0xF3 }, 
  {    9, 0xA3 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x03 }, 
  {   13, 0xB3 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x33 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x71 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x40 }, 
  {   25, 0x60 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0xE2 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0xC6 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x87 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x0F }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x0A }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x02 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x01 }, 
  {   53, 0x81 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x18 }, 
  {   57, 0x89 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x07 }, 
  {   61, 0xFB }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x03 }, 
  {   65, 0xBE }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x20 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x01 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x80 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x04 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x01 }, 
  {   87, 0x00 }, 
  {   88, 0xC0 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0xFF }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0xFF }, 
  {   97, 0x80 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x7C }, 
}; // first_reg_value miniDSP_D_first_reg_values_p1
first_reg_value miniDSP_D_first_reg_values_p2[] = {
  {  102, 0x4D }, 
  {  103, 0x00 }, 
  {  104, 0x3E }, 
  {  105, 0x26 }, 
  {  106, 0x80 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x36 }, 
  {  110, 0x19 }, 
  {  111, 0x00 }, 
  {  112, 0x7C }, 
  {  113, 0x4D }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x36 }, 
  {  117, 0x19 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x01 }, 
  {  121, 0x90 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x7F }, 
  {  125, 0x33 }, 
  {  126, 0xD7 }, 
  {  127, 0x00 }, 
  {    0, 0x1E }, 
  {    8, 0x00 }, 
  {    9, 0xCC }, 
  {   10, 0x29 }, 
  {   11, 0x00 }, 
  {   12, 0xD8 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0xC1 }, 
  {   17, 0x80 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x25 }, 
  {   21, 0xC5 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x55 }, 
  {   26, 0x55 }, 
  {   27, 0x00 }, 
  {   28, 0x21 }, 
  {   29, 0x3F }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x6A }, 
  {   33, 0x6E }, 
  {   34, 0x51 }, 
  {   35, 0x00 }, 
  {   36, 0x98 }, 
  {   37, 0x51 }, 
  {   38, 0xEC }, 
  {   39, 0x00 }, 
  {   40, 0x01 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0xFF }, 
  {   45, 0xFC }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0xC0 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x48 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x6D }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x6A }, 
  {   71, 0x00 }, 
  {    0, 0x50 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x08 }, 
  {   17, 0x08 }, 
  {   18, 0x62 }, 
  {   19, 0x00 }, 
  {   20, 0x08 }, 
  {   21, 0x0C }, 
  {   22, 0x63 }, 
  {   23, 0x00 }, 
  {   24, 0x30 }, 
  {   25, 0x0C }, 
  {   26, 0x4F }, 
  {   27, 0x00 }, 
  {   28, 0x39 }, 
  {   29, 0x28 }, 
  {   30, 0x03 }, 
  {   31, 0x00 }, 
  {   32, 0x39 }, 
  {   33, 0x1C }, 
  {   34, 0x08 }, 
  {   35, 0x00 }, 
  {   36, 0x39 }, 
  {   37, 0x1C }, 
  {   38, 0x02 }, 
  {   39, 0x00 }, 
  {   40, 0x39 }, 
  {   41, 0x18 }, 
  {   42, 0x01 }, 
  {   43, 0x00 }, 
  {   44, 0x39 }, 
  {   45, 0x18 }, 
  {   46, 0x09 }, 
  {   47, 0x00 }, 
  {   48, 0x39 }, 
  {   49, 0x0C }, 
  {   50, 0x0A }, 
  {   51, 0x00 }, 
  {   52, 0xF1 }, 
  {   53, 0x0C }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x31 }, 
  {   61, 0x30 }, 
  {   62, 0x29 }, 
  {   63, 0x00 }, 
  {   64, 0x99 }, 
  {   65, 0x30 }, 
  {   66, 0x2A }, 
  {   67, 0x00 }, 
  {   68, 0x39 }, 
  {   69, 0x34 }, 
  {   70, 0x0E }, 
  {   71, 0x00 }, 
  {   72, 0x39 }, 
  {   73, 0x34 }, 
  {   74, 0x45 }, 
  {   75, 0x00 }, 
  {   76, 0x39 }, 
  {   77, 0x38 }, 
  {   78, 0x2C }, 
  {   79, 0x00 }, 
  {   80, 0x39 }, 
  {   81, 0x38 }, 
  {   82, 0x27 }, 
  {   83, 0x00 }, 
  {   84, 0x39 }, 
  {   85, 0x3C }, 
  {   86, 0x2E }, 
  {   87, 0x00 }, 
  {   88, 0x39 }, 
  {   89, 0x3C }, 
  {   90, 0x25 }, 
  {   91, 0x00 }, 
  {   92, 0x39 }, 
  {   93, 0x40 }, 
  {   94, 0x34 }, 
  {   95, 0x00 }, 
  {   96, 0x39 }, 
  {   97, 0x40 }, 
  {   98, 0x1F }, 
  {   99, 0x00 }, 
  {  100, 0x39 }, 
  {  101, 0x44 }, 
  {  102, 0x11 }, 
  {  103, 0x00 }, 
  {  104, 0x39 }, 
  {  105, 0x44 }, 
  {  106, 0x42 }, 
  {  107, 0x00 }, 
  {  108, 0x39 }, 
  {  109, 0x48 }, 
  {  110, 0x0F }, 
  {  111, 0x00 }, 
  {  112, 0x39 }, 
  {  113, 0x48 }, 
  {  114, 0x44 }, 
  {  115, 0x00 }, 
  {  116, 0x39 }, 
  {  117, 0x4C }, 
  {  118, 0x35 }, 
  {  119, 0x00 }, 
  {  120, 0x39 }, 
  {  121, 0x4C }, 
  {  122, 0x1E }, 
  {  123, 0x00 }, 
  {  124, 0x39 }, 
  {  125, 0x50 }, 
  {  126, 0x30 }, 
  {  127, 0x00 }, 
  {    0, 0x51 }, 
  {    8, 0x39 }, 
  {    9, 0x50 }, 
  {   10, 0x23 }, 
  {   11, 0x00 }, 
  {   12, 0x39 }, 
  {   13, 0x54 }, 
  {   14, 0x13 }, 
  {   15, 0x00 }, 
  {   16, 0x39 }, 
  {   17, 0x54 }, 
  {   18, 0x40 }, 
  {   19, 0x00 }, 
  {   20, 0x39 }, 
  {   21, 0x58 }, 
  {   22, 0x32 }, 
  {   23, 0x00 }, 
  {   24, 0x39 }, 
  {   25, 0x58 }, 
  {   26, 0x21 }, 
  {   27, 0x00 }, 
  {   28, 0x39 }, 
  {   29, 0x5C }, 
  {   30, 0x17 }, 
  {   31, 0x00 }, 
  {   32, 0x39 }, 
  {   33, 0x5C }, 
  {   34, 0x3C }, 
  {   35, 0x00 }, 
  {   36, 0x39 }, 
  {   37, 0x60 }, 
  {   38, 0x37 }, 
  {   39, 0x00 }, 
  {   40, 0x39 }, 
  {   41, 0x60 }, 
  {   42, 0x1C }, 
  {   43, 0x00 }, 
  {   44, 0x39 }, 
  {   45, 0x64 }, 
  {   46, 0x15 }, 
  {   47, 0x00 }, 
  {   48, 0x39 }, 
  {   49, 0x64 }, 
  {   50, 0x3E }, 
  {   51, 0x00 }, 
  {   52, 0x39 }, 
  {   53, 0x68 }, 
  {   54, 0x19 }, 
  {   55, 0x00 }, 
  {   56, 0x39 }, 
  {   57, 0x68 }, 
  {   58, 0x3A }, 
  {   59, 0x00 }, 
  {   60, 0x39 }, 
  {   61, 0x6C }, 
  {   62, 0x16 }, 
  {   63, 0x00 }, 
  {   64, 0x39 }, 
  {   65, 0x6C }, 
  {   66, 0x3D }, 
  {   67, 0x00 }, 
  {   68, 0x39 }, 
  {   69, 0x70 }, 
  {   70, 0x2D }, 
  {   71, 0x00 }, 
  {   72, 0x39 }, 
  {   73, 0x70 }, 
  {   74, 0x26 }, 
  {   75, 0x00 }, 
  {   76, 0x39 }, 
  {   77, 0x74 }, 
  {   78, 0x12 }, 
  {   79, 0x00 }, 
  {   80, 0x39 }, 
  {   81, 0x74 }, 
  {   82, 0x41 }, 
  {   83, 0x00 }, 
  {   84, 0x39 }, 
  {   85, 0x78 }, 
  {   86, 0x38 }, 
  {   87, 0x00 }, 
  {   88, 0x39 }, 
  {   89, 0x78 }, 
  {   90, 0x1B }, 
  {   91, 0x00 }, 
  {   92, 0x39 }, 
  {   93, 0x7C }, 
  {   94, 0x31 }, 
  {   95, 0x00 }, 
  {   96, 0x39 }, 
  {   97, 0x7C }, 
  {   98, 0x22 }, 
  {   99, 0x00 }, 
  {  100, 0x39 }, 
  {  101, 0x80 }, 
  {  102, 0x33 }, 
  {  103, 0x00 }, 
  {  104, 0x39 }, 
  {  105, 0x80 }, 
  {  106, 0x20 }, 
  {  107, 0x00 }, 
  {  108, 0x39 }, 
  {  109, 0x84 }, 
  {  110, 0x2F }, 
  {  111, 0x00 }, 
  {  112, 0x39 }, 
  {  113, 0x84 }, 
  {  114, 0x24 }, 
  {  115, 0x00 }, 
  {  116, 0x39 }, 
  {  117, 0x88 }, 
  {  118, 0x10 }, 
  {  119, 0x00 }, 
  {  120, 0x39 }, 
  {  121, 0x88 }, 
  {  122, 0x43 }, 
  {  123, 0x00 }, 
  {  124, 0x39 }, 
  {  125, 0x8C }, 
  {  126, 0x2B }, 
  {  127, 0x00 }, 
  {    0, 0x52 }, 
  {    8, 0x39 }, 
  {    9, 0x8C }, 
  {   10, 0x28 }, 
  {   11, 0x00 }, 
  {   12, 0x39 }, 
  {   13, 0x90 }, 
  {   14, 0x0D }, 
  {   15, 0x00 }, 
  {   16, 0x39 }, 
  {   17, 0x90 }, 
  {   18, 0x46 }, 
  {   19, 0x00 }, 
  {   20, 0x39 }, 
  {   21, 0x94 }, 
  {   22, 0x14 }, 
  {   23, 0x00 }, 
  {   24, 0x39 }, 
  {   25, 0x94 }, 
  {   26, 0x3F }, 
  {   27, 0x00 }, 
  {   28, 0x39 }, 
  {   29, 0x98 }, 
  {   30, 0x1A }, 
  {   31, 0x00 }, 
  {   32, 0x39 }, 
  {   33, 0x98 }, 
  {   34, 0x39 }, 
  {   35, 0x00 }, 
  {   36, 0x39 }, 
  {   37, 0x9C }, 
  {   38, 0x18 }, 
  {   39, 0x00 }, 
  {   40, 0x39 }, 
  {   41, 0x9C }, 
  {   42, 0x3B }, 
  {   43, 0x00 }, 
  {   44, 0x39 }, 
  {   45, 0xA0 }, 
  {   46, 0x36 }, 
  {   47, 0x00 }, 
  {   48, 0x39 }, 
  {   49, 0xA0 }, 
  {   50, 0x1D }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x50 }, 
  {   61, 0x04 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x50 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x31 }, 
  {   73, 0x04 }, 
  {   74, 0x47 }, 
  {   75, 0x00 }, 
  {   76, 0x39 }, 
  {   77, 0x08 }, 
  {   78, 0x49 }, 
  {   79, 0x00 }, 
  {   80, 0x99 }, 
  {   81, 0x00 }, 
  {   82, 0x46 }, 
  {   83, 0x00 }, 
  {   84, 0x60 }, 
  {   85, 0x1C }, 
  {   86, 0x49 }, 
  {   87, 0x00 }, 
  {   88, 0x38 }, 
  {   89, 0xFC }, 
  {   90, 0x4B }, 
  {   91, 0x00 }, 
  {   92, 0x28 }, 
  {   93, 0x00 }, 
  {   94, 0x48 }, 
  {   95, 0x00 }, 
  {   96, 0x68 }, 
  {   97, 0x18 }, 
  {   98, 0x48 }, 
  {   99, 0x00 }, 
  {  100, 0x58 }, 
  {  101, 0x10 }, 
  {  102, 0x48 }, 
  {  103, 0x00 }, 
  {  104, 0x18 }, 
  {  105, 0x08 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x28 }, 
  {  109, 0x00 }, 
  {  110, 0x4A }, 
  {  111, 0x00 }, 
  {  112, 0x20 }, 
  {  113, 0xFC }, 
  {  114, 0x4D }, 
  {  115, 0x00 }, 
  {  116, 0x30 }, 
  {  117, 0x0C }, 
  {  118, 0x4D }, 
  {  119, 0x00 }, 
  {  120, 0x30 }, 
  {  121, 0x28 }, 
  {  122, 0x52 }, 
  {  123, 0x00 }, 
  {  124, 0xD8 }, 
  {  125, 0x24 }, 
  {  126, 0x51 }, 
  {  127, 0x00 }, 
  {    0, 0x53 }, 
  {    8, 0x20 }, 
  {    9, 0x04 }, 
  {   10, 0x50 }, 
  {   11, 0x00 }, 
  {   12, 0x38 }, 
  {   13, 0x20 }, 
  {   14, 0x50 }, 
  {   15, 0x00 }, 
  {   16, 0xD8 }, 
  {   17, 0x2C }, 
  {   18, 0x54 }, 
  {   19, 0x00 }, 
  {   20, 0x38 }, 
  {   21, 0x30 }, 
  {   22, 0x55 }, 
  {   23, 0x00 }, 
  {   24, 0x30 }, 
  {   25, 0x3C }, 
  {   26, 0x55 }, 
  {   27, 0x00 }, 
  {   28, 0xD8 }, 
  {   29, 0x38 }, 
  {   30, 0x54 }, 
  {   31, 0x00 }, 
  {   32, 0x98 }, 
  {   33, 0x34 }, 
  {   34, 0x53 }, 
  {   35, 0x00 }, 
  {   36, 0xD8 }, 
  {   37, 0x40 }, 
  {   38, 0x57 }, 
  {   39, 0x00 }, 
  {   40, 0x38 }, 
  {   41, 0x44 }, 
  {   42, 0x58 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x50 }, 
  {   46, 0x58 }, 
  {   47, 0x00 }, 
  {   48, 0xD8 }, 
  {   49, 0x4C }, 
  {   50, 0x57 }, 
  {   51, 0x00 }, 
  {   52, 0x98 }, 
  {   53, 0x48 }, 
  {   54, 0x56 }, 
  {   55, 0x00 }, 
  {   56, 0xD8 }, 
  {   57, 0x54 }, 
  {   58, 0x5A }, 
  {   59, 0x00 }, 
  {   60, 0x38 }, 
  {   61, 0x58 }, 
  {   62, 0x5B }, 
  {   63, 0x00 }, 
  {   64, 0x30 }, 
  {   65, 0x64 }, 
  {   66, 0x5B }, 
  {   67, 0x00 }, 
  {   68, 0xD8 }, 
  {   69, 0x60 }, 
  {   70, 0x5A }, 
  {   71, 0x00 }, 
  {   72, 0x98 }, 
  {   73, 0x5C }, 
  {   74, 0x59 }, 
  {   75, 0x00 }, 
  {   76, 0xD8 }, 
  {   77, 0x68 }, 
  {   78, 0x5D }, 
  {   79, 0x00 }, 
  {   80, 0x38 }, 
  {   81, 0x6C }, 
  {   82, 0x5E }, 
  {   83, 0x00 }, 
  {   84, 0x30 }, 
  {   85, 0x78 }, 
  {   86, 0x5E }, 
  {   87, 0x00 }, 
  {   88, 0xD8 }, 
  {   89, 0x74 }, 
  {   90, 0x5D }, 
  {   91, 0x00 }, 
  {   92, 0x98 }, 
  {   93, 0x70 }, 
  {   94, 0x5C }, 
  {   95, 0x00 }, 
  {   96, 0xD8 }, 
  {   97, 0x7C }, 
  {   98, 0x60 }, 
  {   99, 0x00 }, 
  {  100, 0x38 }, 
  {  101, 0x80 }, 
  {  102, 0x61 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x20 }, 
  {  113, 0x00 }, 
  {  114, 0x5F }, 
  {  115, 0x00 }, 
  {  116, 0x31 }, 
  {  117, 0xDB }, 
  {  118, 0xFB }, 
  {  119, 0x00 }, 
  {  120, 0x31 }, 
  {  121, 0xA4 }, 
  {  122, 0x6D }, 
  {  123, 0x00 }, 
  {  124, 0x39 }, 
  {  125, 0xAF }, 
  {  126, 0xFB }, 
  {  127, 0x00 }, 
  {    0, 0x54 }, 
  {    8, 0x28 }, 
  {    9, 0xD8 }, 
  {   10, 0x68 }, 
  {   11, 0x00 }, 
  {   12, 0x81 }, 
  {   13, 0xE7 }, 
  {   14, 0xFB }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x13 }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x88 }, 
  {   25, 0x08 }, 
  {   26, 0x02 }, 
  {   27, 0x00 }, 
  {   28, 0x28 }, 
  {   29, 0x08 }, 
  {   30, 0x6C }, 
  {   31, 0x00 }, 
  {   32, 0x88 }, 
  {   33, 0x00 }, 
  {   34, 0x02 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x20 }, 
  {   41, 0x04 }, 
  {   42, 0x6C }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x0C }, 
  {   46, 0x6B }, 
  {   47, 0x00 }, 
  {   48, 0x81 }, 
  {   49, 0xEB }, 
  {   50, 0xFB }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x39 }, 
  {   57, 0xB3 }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x88 }, 
  {   61, 0x04 }, 
  {   62, 0x02 }, 
  {   63, 0x00 }, 
  {   64, 0x20 }, 
  {   65, 0x04 }, 
  {   66, 0x6A }, 
  {   67, 0x00 }, 
  {   68, 0x88 }, 
  {   69, 0x00 }, 
  {   70, 0x02 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x20 }, 
  {   77, 0x04 }, 
  {   78, 0x6A }, 
  {   79, 0x00 }, 
  {   80, 0x31 }, 
  {   81, 0xDC }, 
  {   82, 0x6F }, 
  {   83, 0x00 }, 
  {   84, 0x69 }, 
  {   85, 0xE0 }, 
  {   86, 0x48 }, 
  {   87, 0x00 }, 
  {   88, 0x31 }, 
  {   89, 0xDC }, 
  {   90, 0x71 }, 
  {   91, 0x00 }, 
  {   92, 0x71 }, 
  {   93, 0xE0 }, 
  {   94, 0x74 }, 
  {   95, 0x00 }, 
  {   96, 0x20 }, 
  {   97, 0x00 }, 
  {   98, 0x6E }, 
  {   99, 0x00 }, 
  {  100, 0x31 }, 
  {  101, 0xEC }, 
  {  102, 0x73 }, 
  {  103, 0x00 }, 
  {  104, 0x20 }, 
  {  105, 0x00 }, 
  {  106, 0x70 }, 
  {  107, 0x00 }, 
  {  108, 0x49 }, 
  {  109, 0xA8 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x38 }, 
  {  113, 0x14 }, 
  {  114, 0x73 }, 
  {  115, 0x00 }, 
  {  116, 0x80 }, 
  {  117, 0x08 }, 
  {  118, 0x70 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x20 }, 
  {  125, 0x00 }, 
  {  126, 0x65 }, 
  {  127, 0x00 }, 
  {    0, 0x55 }, 
  {    8, 0x88 }, 
  {    9, 0x0C }, 
  {   10, 0x02 }, 
  {   11, 0x00 }, 
  {   12, 0x30 }, 
  {   13, 0x0C }, 
  {   14, 0x65 }, 
  {   15, 0x00 }, 
  {   16, 0x88 }, 
  {   17, 0x00 }, 
  {   18, 0x02 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x0C }, 
  {   22, 0x70 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x30 }, 
  {   29, 0x0C }, 
  {   30, 0x6C }, 
  {   31, 0x00 }, 
  {   32, 0x20 }, 
  {   33, 0x04 }, 
  {   34, 0x72 }, 
  {   35, 0x00 }, 
  {   36, 0x80 }, 
  {   37, 0x13 }, 
  {   38, 0xFB }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x0C }, 
  {   42, 0x73 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x88 }, 
  {   49, 0x04 }, 
  {   50, 0x01 }, 
  {   51, 0x00 }, 
  {   52, 0x88 }, 
  {   53, 0x00 }, 
  {   54, 0x01 }, 
  {   55, 0x00 }, 
  {   56, 0x20 }, 
  {   57, 0x04 }, 
  {   58, 0x72 }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x0C }, 
  {   62, 0x6A }, 
  {   63, 0x00 }, 
  {   64, 0x81 }, 
  {   65, 0xEB }, 
  {   66, 0xFB }, 
  {   67, 0x00 }, 
  {   68, 0x30 }, 
  {   69, 0x0C }, 
  {   70, 0x70 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x88 }, 
  {   77, 0x04 }, 
  {   78, 0x01 }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x00 }, 
  {   82, 0x01 }, 
  {   83, 0x00 }, 
  {   84, 0x20 }, 
  {   85, 0x04 }, 
  {   86, 0x72 }, 
  {   87, 0x00 }, 
  {   88, 0x30 }, 
  {   89, 0x0C }, 
  {   90, 0x72 }, 
  {   91, 0x00 }, 
  {   92, 0x81 }, 
  {   93, 0xB8 }, 
  {   94, 0x68 }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0x0C }, 
  {   98, 0x68 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x88 }, 
  {  105, 0x10 }, 
  {  106, 0x01 }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x00 }, 
  {  110, 0x01 }, 
  {  111, 0x00 }, 
  {  112, 0x20 }, 
  {  113, 0x04 }, 
  {  114, 0x72 }, 
  {  115, 0x00 }, 
  {  116, 0x30 }, 
  {  117, 0x0C }, 
  {  118, 0x77 }, 
  {  119, 0x00 }, 
  {  120, 0x80 }, 
  {  121, 0x0C }, 
  {  122, 0x76 }, 
  {  123, 0x00 }, 
  {  124, 0x31 }, 
  {  125, 0xF3 }, 
  {  126, 0xFB }, 
  {  127, 0x00 }, 
  {    0, 0x56 }, 
  {    8, 0x31 }, 
  {    9, 0xB7 }, 
  {   10, 0xFB }, 
  {   11, 0x00 }, 
  {   12, 0x88 }, 
  {   13, 0x04 }, 
  {   14, 0x02 }, 
  {   15, 0x00 }, 
  {   16, 0x20 }, 
  {   17, 0xE8 }, 
  {   18, 0x77 }, 
  {   19, 0x00 }, 
  {   20, 0x88 }, 
  {   21, 0x00 }, 
  {   22, 0x02 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x31 }, 
  {   33, 0xC4 }, 
  {   34, 0x77 }, 
  {   35, 0x00 }, 
  {   36, 0x28 }, 
  {   37, 0xE8 }, 
  {   38, 0x67 }, 
  {   39, 0x00 }, 
  {   40, 0x39 }, 
  {   41, 0xCC }, 
  {   42, 0x67 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x49 }, 
  {   49, 0xA8 }, 
  {   50, 0x07 }, 
  {   51, 0x00 }, 
  {   52, 0x31 }, 
  {   53, 0xD0 }, 
  {   54, 0x77 }, 
  {   55, 0x00 }, 
  {   56, 0x39 }, 
  {   57, 0xD4 }, 
  {   58, 0x67 }, 
  {   59, 0x00 }, 
  {   60, 0x28 }, 
  {   61, 0x3C }, 
  {   62, 0x66 }, 
  {   63, 0x00 }, 
  {   64, 0x39 }, 
  {   65, 0xBC }, 
  {   66, 0x66 }, 
  {   67, 0x00 }, 
  {   68, 0x81 }, 
  {   69, 0xC0 }, 
  {   70, 0x67 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x28 }, 
  {   77, 0x3C }, 
  {   78, 0x76 }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x10 }, 
  {   82, 0x02 }, 
  {   83, 0x00 }, 
  {   84, 0x30 }, 
  {   85, 0x14 }, 
  {   86, 0x72 }, 
  {   87, 0x00 }, 
  {   88, 0x88 }, 
  {   89, 0x00 }, 
  {   90, 0x02 }, 
  {   91, 0x00 }, 
  {   92, 0x30 }, 
  {   93, 0x08 }, 
  {   94, 0x72 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x20 }, 
  {  105, 0xF8 }, 
  {  106, 0x75 }, 
  {  107, 0x00 }, 
  {  108, 0x31 }, 
  {  109, 0xF4 }, 
  {  110, 0x75 }, 
  {  111, 0x00 }, 
  {  112, 0xD9 }, 
  {  113, 0xF8 }, 
  {  114, 0x79 }, 
  {  115, 0x00 }, 
  {  116, 0x39 }, 
  {  117, 0xFC }, 
  {  118, 0x7A }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x50 }, 
  {  125, 0x10 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x57 }, 
  {    8, 0x20 }, 
  {    9, 0x00 }, 
  {   10, 0x78 }, 
  {   11, 0x00 }, 
  {   12, 0x38 }, 
  {   13, 0x14 }, 
  {   14, 0x63 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x20 }, 
  {   25, 0x00 }, 
  {   26, 0x64 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x31 }, 
  {   45, 0x0C }, 
  {   46, 0x03 }, 
  {   47, 0x00 }, 
  {   48, 0x39 }, 
  {   49, 0x0C }, 
  {   50, 0x06 }, 
  {   51, 0x00 }, 
  {   52, 0x39 }, 
  {   53, 0x18 }, 
  {   54, 0x07 }, 
  {   55, 0x00 }, 
  {   56, 0x39 }, 
  {   57, 0x18 }, 
  {   58, 0x02 }, 
  {   59, 0x00 }, 
  {   60, 0x39 }, 
  {   61, 0x1C }, 
  {   62, 0x01 }, 
  {   63, 0x00 }, 
  {   64, 0x39 }, 
  {   65, 0x1C }, 
  {   66, 0x08 }, 
  {   67, 0x00 }, 
  {   68, 0x39 }, 
  {   69, 0x28 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x39 }, 
  {   73, 0x28 }, 
  {   74, 0x09 }, 
  {   75, 0x00 }, 
  {   76, 0x39 }, 
  {   77, 0x2C }, 
  {   78, 0x05 }, 
  {   79, 0x00 }, 
}; // first_reg_value miniDSP_D_first_reg_values_p2
first_reg_value miniDSP_D_first_reg_values_p3[] = {
  {   80, 0x31 }, 
  {   81, 0x2C }, 
  {   82, 0x0B }, 
  {   83, 0x00 }, 
  {   84, 0x39 }, 
  {   85, 0x28 }, 
  {   86, 0x06 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x00 }, 
  {   90, 0x0C }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x20 }, 
  {   97, 0x04 }, 
  {   98, 0x4E }, 
  {   99, 0x00 }, 
  {  100, 0x31 }, 
  {  101, 0x13 }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x30 }, 
  {  105, 0x0C }, 
  {  106, 0x64 }, 
  {  107, 0x00 }, 
  {  108, 0x30 }, 
  {  109, 0x0C }, 
  {  110, 0x63 }, 
  {  111, 0x00 }, 
  {  112, 0x88 }, 
  {  113, 0x18 }, 
  {  114, 0x02 }, 
  {  115, 0x00 }, 
  {  116, 0x20 }, 
  {  117, 0x04 }, 
  {  118, 0x7B }, 
  {  119, 0x00 }, 
  {  120, 0x88 }, 
  {  121, 0x00 }, 
  {  122, 0x02 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x58 }, 
  {    8, 0x20 }, 
  {    9, 0x04 }, 
  {   10, 0x7B }, 
  {   11, 0x00 }, 
  {   12, 0x08 }, 
  {   13, 0x00 }, 
  {   14, 0x0A }, 
  {   15, 0x00 }, 
  {   16, 0x30 }, 
  {   17, 0x04 }, 
  {   18, 0x7B }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x20 }, 
  {   29, 0x14 }, 
  {   30, 0x7C }, 
  {   31, 0x00 }, 
  {   32, 0x30 }, 
  {   33, 0x0C }, 
  {   34, 0x7C }, 
  {   35, 0x00 }, 
  {   36, 0x30 }, 
  {   37, 0x0C }, 
  {   38, 0x7C }, 
  {   39, 0x00 }, 
  {   40, 0x18 }, 
  {   41, 0x00 }, 
  {   42, 0x03 }, 
  {   43, 0x00 }, 
  {   44, 0x18 }, 
  {   45, 0x04 }, 
  {   46, 0x03 }, 
  {   47, 0x00 }, 
  {   48, 0x30 }, 
  {   49, 0x0C }, 
  {   50, 0x62 }, 
  {   51, 0x00 }, 
  {   52, 0x30 }, 
  {   53, 0x8C }, 
  {   54, 0x7F }, 
  {   55, 0x00 }, 
  {   56, 0xD8 }, 
  {   57, 0x88 }, 
  {   58, 0x7E }, 
  {   59, 0x00 }, 
  {   60, 0x20 }, 
  {   61, 0x04 }, 
  {   62, 0x7D }, 
  {   63, 0x00 }, 
  {   64, 0x38 }, 
  {   65, 0x84 }, 
  {   66, 0x7D }, 
  {   67, 0x00 }, 
  {   68, 0xD8 }, 
  {   69, 0x90 }, 
  {   70, 0x81 }, 
  {   71, 0x00 }, 
  {   72, 0x38 }, 
  {   73, 0x94 }, 
  {   74, 0x82 }, 
  {   75, 0x00 }, 
  {   76, 0x30 }, 
  {   77, 0xA0 }, 
  {   78, 0x82 }, 
  {   79, 0x00 }, 
  {   80, 0xD8 }, 
  {   81, 0x9C }, 
  {   82, 0x81 }, 
  {   83, 0x00 }, 
  {   84, 0x98 }, 
  {   85, 0x98 }, 
  {   86, 0x80 }, 
  {   87, 0x00 }, 
  {   88, 0xD8 }, 
  {   89, 0xA4 }, 
  {   90, 0x84 }, 
  {   91, 0x00 }, 
  {   92, 0x38 }, 
  {   93, 0xA8 }, 
  {   94, 0x85 }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0xB4 }, 
  {   98, 0x85 }, 
  {   99, 0x00 }, 
  {  100, 0xD8 }, 
  {  101, 0xB0 }, 
  {  102, 0x84 }, 
  {  103, 0x00 }, 
  {  104, 0x98 }, 
  {  105, 0xAC }, 
  {  106, 0x83 }, 
  {  107, 0x00 }, 
  {  108, 0xD8 }, 
  {  109, 0xB8 }, 
  {  110, 0x87 }, 
  {  111, 0x00 }, 
  {  112, 0x38 }, 
  {  113, 0xBC }, 
  {  114, 0x88 }, 
  {  115, 0x00 }, 
  {  116, 0x30 }, 
  {  117, 0xC8 }, 
  {  118, 0x88 }, 
  {  119, 0x00 }, 
  {  120, 0xD8 }, 
  {  121, 0xC4 }, 
  {  122, 0x87 }, 
  {  123, 0x00 }, 
  {  124, 0x98 }, 
  {  125, 0xC0 }, 
  {  126, 0x86 }, 
  {  127, 0x00 }, 
  {    0, 0x59 }, 
  {    8, 0xD8 }, 
  {    9, 0xCC }, 
  {   10, 0x8A }, 
  {   11, 0x00 }, 
  {   12, 0x38 }, 
  {   13, 0xD0 }, 
  {   14, 0x8B }, 
  {   15, 0x00 }, 
  {   16, 0x30 }, 
  {   17, 0xDC }, 
  {   18, 0x8B }, 
  {   19, 0x00 }, 
  {   20, 0xD8 }, 
  {   21, 0xD8 }, 
  {   22, 0x8A }, 
  {   23, 0x00 }, 
  {   24, 0x98 }, 
  {   25, 0xD4 }, 
  {   26, 0x89 }, 
  {   27, 0x00 }, 
  {   28, 0xD8 }, 
  {   29, 0xE0 }, 
  {   30, 0x8D }, 
  {   31, 0x00 }, 
  {   32, 0x38 }, 
  {   33, 0xE4 }, 
  {   34, 0x8E }, 
  {   35, 0x00 }, 
  {   36, 0x30 }, 
  {   37, 0xF0 }, 
  {   38, 0x8E }, 
  {   39, 0x00 }, 
  {   40, 0xD8 }, 
  {   41, 0xEC }, 
  {   42, 0x8D }, 
  {   43, 0x00 }, 
  {   44, 0x98 }, 
  {   45, 0xE8 }, 
  {   46, 0x8C }, 
  {   47, 0x00 }, 
  {   48, 0xD8 }, 
  {   49, 0xF4 }, 
  {   50, 0x90 }, 
  {   51, 0x00 }, 
  {   52, 0x38 }, 
  {   53, 0xF8 }, 
  {   54, 0x91 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x20 }, 
  {   65, 0x00 }, 
  {   66, 0x8F }, 
  {   67, 0x00 }, 
  {   68, 0x31 }, 
  {   69, 0x23 }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x82 }, 
  {   73, 0x10 }, 
  {   74, 0x98 }, 
  {   75, 0x00 }, 
  {   76, 0x3A }, 
  {   77, 0x10 }, 
  {   78, 0x96 }, 
  {   79, 0x00 }, 
  {   80, 0x20 }, 
  {   81, 0x04 }, 
  {   82, 0x97 }, 
  {   83, 0x00 }, 
  {   84, 0x88 }, 
  {   85, 0x08 }, 
  {   86, 0x06 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0xE0 }, 
  {   90, 0x94 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x30 }, 
  {  101, 0x0C }, 
  {  102, 0x96 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x00 }, 
  {  110, 0x17 }, 
  {  111, 0x00 }, 
  {  112, 0x30 }, 
  {  113, 0x0C }, 
  {  114, 0x94 }, 
  {  115, 0x00 }, 
  {  116, 0x80 }, 
  {  117, 0x13 }, 
  {  118, 0xFB }, 
  {  119, 0x00 }, 
  {  120, 0x38 }, 
  {  121, 0x0C }, 
  {  122, 0x96 }, 
  {  123, 0x00 }, 
  {  124, 0x82 }, 
  {  125, 0x10 }, 
  {  126, 0x97 }, 
  {  127, 0x00 }, 
  {    0, 0x5A }, 
  {    8, 0x88 }, 
  {    9, 0x18 }, 
  {   10, 0x09 }, 
  {   11, 0x00 }, 
  {   12, 0x88 }, 
  {   13, 0x08 }, 
  {   14, 0x11 }, 
  {   15, 0x00 }, 
  {   16, 0x20 }, 
  {   17, 0x04 }, 
  {   18, 0x95 }, 
  {   19, 0x00 }, 
  {   20, 0x88 }, 
  {   21, 0x10 }, 
  {   22, 0x11 }, 
  {   23, 0x00 }, 
  {   24, 0x30 }, 
  {   25, 0x0C }, 
  {   26, 0x97 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x30 }, 
  {   33, 0x13 }, 
  {   34, 0xFB }, 
  {   35, 0x00 }, 
  {   36, 0x20 }, 
  {   37, 0x04 }, 
  {   38, 0x95 }, 
  {   39, 0x00 }, 
  {   40, 0x42 }, 
  {   41, 0x08 }, 
  {   42, 0x02 }, 
  {   43, 0x00 }, 
  {   44, 0x88 }, 
  {   45, 0x00 }, 
  {   46, 0x11 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x20 }, 
  {   53, 0x04 }, 
  {   54, 0x95 }, 
  {   55, 0x00 }, 
  {   56, 0x88 }, 
  {   57, 0x0C }, 
  {   58, 0x08 }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x0C }, 
  {   62, 0x97 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x30 }, 
  {   69, 0x13 }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x20 }, 
  {   73, 0x04 }, 
  {   74, 0x95 }, 
  {   75, 0x00 }, 
  {   76, 0x42 }, 
  {   77, 0x08 }, 
  {   78, 0x02 }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x00 }, 
  {   82, 0x08 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x04 }, 
  {   90, 0x95 }, 
  {   91, 0x00 }, 
  {   92, 0x42 }, 
  {   93, 0x08 }, 
  {   94, 0x02 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x30 }, 
  {  105, 0x0C }, 
  {  106, 0x94 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x20 }, 
  {  117, 0x04 }, 
  {  118, 0x93 }, 
  {  119, 0x00 }, 
  {  120, 0x32 }, 
  {  121, 0x08 }, 
  {  122, 0x8F }, 
  {  123, 0x00 }, 
  {  124, 0x32 }, 
  {  125, 0x0B }, 
  {  126, 0xFB }, 
  {  127, 0x00 }, 
  {    0, 0x5B }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x20 }, 
  {   13, 0x04 }, 
  {   14, 0x92 }, 
  {   15, 0x00 }, 
  {   16, 0x42 }, 
  {   17, 0x0C }, 
  {   18, 0x3F }, 
  {   19, 0x00 }, 
  {   20, 0x31 }, 
  {   21, 0x14 }, 
  {   22, 0x9A }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x20 }, 
  {   33, 0x08 }, 
  {   34, 0x99 }, 
  {   35, 0x00 }, 
  {   36, 0x31 }, 
  {   37, 0x27 }, 
  {   38, 0xFB }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x20 }, 
  {   49, 0x00 }, 
  {   50, 0x9B }, 
  {   51, 0x00 }, 
  {   52, 0x32 }, 
  {   53, 0x17 }, 
  {   54, 0xFB }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x38 }, 
  {   61, 0x03 }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x17 }, 
  {   66, 0xFE }, 
  {   67, 0x00 }, 
  {   68, 0x08 }, 
  {   69, 0x00 }, 
  {   70, 0x06 }, 
  {   71, 0x00 }, 
  {   72, 0x32 }, 
  {   73, 0x1B }, 
  {   74, 0xFB }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x38 }, 
  {   81, 0x03 }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x88 }, 
  {   85, 0x17 }, 
  {   86, 0xFE }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x08 }, 
  {   93, 0x00 }, 
  {   94, 0x03 }, 
  {   95, 0x00 }, 
  {   96, 0x32 }, 
  {   97, 0x1F }, 
  {   98, 0xFB }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x38 }, 
  {  105, 0x03 }, 
  {  106, 0xFB }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x17 }, 
  {  110, 0xFE }, 
  {  111, 0x00 }, 
  {  112, 0x10 }, 
  {  113, 0x10 }, 
  {  114, 0x92 }, 
  {  115, 0x00 }, 
  {  116, 0x10 }, 
  {  117, 0x14 }, 
  {  118, 0x5F }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x88 }, 
  {  125, 0x03 }, 
  {  126, 0xFF }, 
  {  127, 0x00 }, 
  {    0, 0x00 }, 
  {   61, 0x00 }, 
  {   15, 0x18 }, 
  {   16, 0x00 }, 
  {    0, 0x2C }, 
  {    8, 0xA0 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x10 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x5A }, 
  {   17, 0x9D }, 
  {   18, 0xF8 }, 
  {   19, 0x00 }, 
  {   20, 0x5A }, 
  {   21, 0x9D }, 
  {   22, 0xF8 }, 
  {   23, 0x00 }, 
  {   24, 0x40 }, 
  {   25, 0x26 }, 
  {   26, 0xE7 }, 
  {   27, 0x00 }, 
  {   28, 0x5A }, 
  {   29, 0x9E }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x0F }, 
  {   33, 0x0A }, 
  {   34, 0x57 }, 
  {   35, 0x00 }, 
  {   36, 0x70 }, 
  {   37, 0xF5 }, 
  {   38, 0xA9 }, 
  {   39, 0x00 }, 
  {   40, 0x20 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0xE0 }, 
  {   49, 0x51 }, 
  {   50, 0xEC }, 
  {   51, 0x00 }, 
  {   52, 0x33 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x14 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x32 }, 
  {   69, 0x5D }, 
  {   70, 0x34 }, 
  {   71, 0x00 }, 
  {   72, 0x4D }, 
  {   73, 0xA2 }, 
  {   74, 0xCC }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x08 }, 
  {   78, 0x31 }, 
  {   79, 0x00 }, 
  {   80, 0x7F }, 
  {   81, 0xF7 }, 
  {   82, 0xCF }, 
  {   83, 0x00 }, 
  {   84, 0xFF }, 
  {   85, 0xFF }, 
  {   86, 0xFF }, 
  {   87, 0x00 }, 
  {   88, 0x80 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x40 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x7F }, 
  {  101, 0xFF }, 
  {  102, 0xFF }, 
  {  103, 0x00 }, 
  {  104, 0xC0 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0xD7 }, 
  {  113, 0x41 }, 
  {  114, 0xA0 }, 
  {  115, 0x00 }, 
  {  116, 0xFF }, 
  {  117, 0xF0 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x88 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x18 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x2D }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0xD0 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x03 }, 
  {   30, 0x84 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0xB2 }, 
  {   34, 0x55 }, 
  {   35, 0x00 }, 
  {   36, 0x0E }, 
  {   37, 0x5B }, 
  {   38, 0xDE }, 
  {   39, 0x00 }, 
  {   40, 0x7F }, 
  {   41, 0xFF }, 
  {   42, 0xFF }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x02 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x20 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x51 }, 
  {   58, 0x26 }, 
  {   59, 0x00 }, 
  {   60, 0x40 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x0C }, 
  {   66, 0xDC }, 
  {   67, 0x00 }, 
  {   68, 0x02 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x16 }, 
  {   82, 0x5A }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x37 }, 
  {   86, 0x56 }, 
  {   87, 0x00 }, 
  {   88, 0x10 }, 
  {   89, 0xA9 }, 
  {   90, 0xBF }, 
  {   91, 0x00 }, 
  {   92, 0x7F }, 
  {   93, 0xFF }, 
  {   94, 0xFF }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x02 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0xE0 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x0C }, 
  {  109, 0x9E }, 
  {  110, 0x80 }, 
  {  111, 0x00 }, 
  {  112, 0xC0 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x4F }, 
  {  117, 0x9F }, 
  {  118, 0x16 }, 
  {  119, 0x00 }, 
  {  120, 0x02 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x2E }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x20 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x40 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0xE0 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0xC0 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x11 }, 
  {   29, 0x80 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x18 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0xC0 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x2F }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
}; // first_reg_value miniDSP_D_first_reg_values_p3
first_reg_value miniDSP_D_first_reg_values_p4[] = {
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x30 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x31 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x32 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x33 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x34 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {    0, 0x3E }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x3F }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x40 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x41 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x20 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x10 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x01 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x80 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x04 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0xC0 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0xE0 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0xF0 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0xFC }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0xFF }, 
  {   93, 0xFF }, 
  {   94, 0xFF }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
}; // first_reg_value miniDSP_D_first_reg_values_p4
first_reg_value miniDSP_D_first_reg_values_p5[] = {
  {   97, 0x00 }, 
  {   98, 0x0C }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x10 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x7E }, 
  {  113, 0xF0 }, 
  {  114, 0x11 }, 
  {  115, 0x00 }, 
  {  116, 0x01 }, 
  {  117, 0x0F }, 
  {  118, 0xEF }, 
  {  119, 0x00 }, 
  {  120, 0x7E }, 
  {  121, 0x68 }, 
  {  122, 0xF3 }, 
  {  123, 0x00 }, 
  {  124, 0x01 }, 
  {  125, 0x97 }, 
  {  126, 0x0D }, 
  {  127, 0x00 }, 
  {    0, 0x42 }, 
  {    8, 0x78 }, 
  {    9, 0x3E }, 
  {   10, 0xB0 }, 
  {   11, 0x00 }, 
  {   12, 0x7E }, 
  {   13, 0xF0 }, 
  {   14, 0x11 }, 
  {   15, 0x00 }, 
  {   16, 0x7F }, 
  {   17, 0xAE }, 
  {   18, 0x2F }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x51 }, 
  {   22, 0xD1 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x50 }, 
  {   27, 0x00 }, 
  {   28, 0x01 }, 
  {   29, 0x90 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0xFF }, 
  {   33, 0xFF }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0xB0 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0xC1 }, 
  {   41, 0x80 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x03 }, 
  {   46, 0x20 }, 
  {   47, 0x00 }, 
  {   48, 0x4B }, 
  {   49, 0xA0 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x80 }, 
  {   53, 0x9B }, 
  {   54, 0x10 }, 
  {   55, 0x00 }, 
  {   56, 0xFE }, 
  {   57, 0x02 }, 
  {   58, 0x6C }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x68 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x09 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x04 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x09 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x08 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x12 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x10 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x3F }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x38 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x87 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x3C }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0xC8 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x43 }, 
  {    8, 0xF0 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0xC0 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x80 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x7F }, 
  {   21, 0xFF }, 
  {   22, 0xFF }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0xFF }, 
  {   33, 0xDC }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0xFF }, 
  {   37, 0xC0 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0xFF }, 
  {   41, 0x0A }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0xFF }, 
  {   45, 0x7B }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0xFD }, 
  {   49, 0x21 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0xFE }, 
  {   53, 0x54 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0xFA }, 
  {   57, 0xBE }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0xF2 }, 
  {   61, 0xAB }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x28 }, 
  {   65, 0xA9 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x29 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x02 }, 
  {   73, 0x30 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0xB7 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x5E }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x01 }, 
  {   85, 0x47 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x03 }, 
  {   89, 0xD3 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x07 }, 
  {   93, 0xBD }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x40 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x14 }, 
  {  101, 0xEF }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0xEF }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x01 }, 
  {  109, 0x86 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x2B }, 
  {  113, 0xE8 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0xFE }, 
  {  117, 0x88 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0xFE }, 
  {  121, 0x15 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0xF8 }, 
  {  125, 0xF9 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x44 }, 
  {    8, 0xFF }, 
  {    9, 0xF8 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0xFF }, 
  {   13, 0xD8 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0xFF }, 
  {   17, 0xF6 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0xFE }, 
  {   21, 0xBF }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x3A }, 
  {   25, 0xD8 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x15 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x06 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x67 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x4F }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x01 }, 
  {   45, 0xD5 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x24 }, 
  {   49, 0x89 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0xFC }, 
  {   53, 0xAB }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0xFF }, 
  {   57, 0x19 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0xF3 }, 
  {   61, 0xE3 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x06 }, 
  {   65, 0x1E }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x7F }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x02 }, 
  {   74, 0xFC }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x02 }, 
  {   78, 0x8A }, 
  {   79, 0x00 }, 
  {    0, 0x98 }, 
  {    8, 0x10 }, 
  {    9, 0x01 }, 
  {   10, 0x7F }, 
  {   11, 0x00 }, 
  {   12, 0x10 }, 
  {   13, 0x05 }, 
  {   14, 0x7F }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x08 }, 
  {   25, 0x00 }, 
  {   26, 0x04 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x08 }, 
  {   33, 0x08 }, 
  {   34, 0x05 }, 
  {   35, 0x00 }, 
  {   36, 0x08 }, 
  {   37, 0x0C }, 
  {   38, 0x06 }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x54 }, 
  {   42, 0x15 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x57 }, 
  {   46, 0xFB }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x88 }, 
  {   53, 0x18 }, 
  {   54, 0x04 }, 
  {   55, 0x00 }, 
  {   56, 0x20 }, 
  {   57, 0xEC }, 
  {   58, 0x11 }, 
  {   59, 0x00 }, 
  {   60, 0x31 }, 
  {   61, 0x17 }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x20 }, 
  {   65, 0xEC }, 
  {   66, 0x13 }, 
  {   67, 0x00 }, 
  {   68, 0x88 }, 
  {   69, 0x00 }, 
  {   70, 0x04 }, 
  {   71, 0x00 }, 
  {   72, 0x31 }, 
  {   73, 0x17 }, 
  {   74, 0xFB }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x04 }, 
  {   90, 0x14 }, 
  {   91, 0x00 }, 
  {   92, 0x60 }, 
  {   93, 0x18 }, 
  {   94, 0x05 }, 
  {   95, 0x00 }, 
  {   96, 0x38 }, 
  {   97, 0x1C }, 
  {   98, 0x09 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x20 }, 
  {  109, 0x00 }, 
  {  110, 0x08 }, 
  {  111, 0x00 }, 
  {  112, 0x30 }, 
  {  113, 0x54 }, 
  {  114, 0x08 }, 
  {  115, 0x00 }, 
  {  116, 0x80 }, 
  {  117, 0x6B }, 
  {  118, 0xFB }, 
  {  119, 0x00 }, 
  {  120, 0x80 }, 
  {  121, 0x6F }, 
  {  122, 0xFB }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x99 }, 
  {    8, 0x88 }, 
  {    9, 0x0C }, 
  {   10, 0x09 }, 
  {   11, 0x00 }, 
  {   12, 0x88 }, 
  {   13, 0x10 }, 
  {   14, 0x04 }, 
  {   15, 0x00 }, 
  {   16, 0x18 }, 
  {   17, 0x10 }, 
  {   18, 0x03 }, 
  {   19, 0x00 }, 
  {   20, 0x09 }, 
  {   21, 0x10 }, 
  {   22, 0x19 }, 
  {   23, 0x00 }, 
  {   24, 0x30 }, 
  {   25, 0x5B }, 
  {   26, 0xFB }, 
  {   27, 0x00 }, 
  {   28, 0x88 }, 
  {   29, 0x00 }, 
  {   30, 0x09 }, 
  {   31, 0x00 }, 
  {   32, 0x18 }, 
  {   33, 0x10 }, 
  {   34, 0x0D }, 
  {   35, 0x00 }, 
  {   36, 0x09 }, 
  {   37, 0x10 }, 
  {   38, 0x19 }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x73 }, 
  {   42, 0xFB }, 
  {   43, 0x00 }, 
  {   44, 0x88 }, 
  {   45, 0x00 }, 
  {   46, 0x05 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x18 }, 
  {   57, 0x10 }, 
  {   58, 0x01 }, 
  {   59, 0x00 }, 
  {   60, 0x09 }, 
  {   61, 0x10 }, 
  {   62, 0x19 }, 
  {   63, 0x00 }, 
  {   64, 0x30 }, 
  {   65, 0x77 }, 
  {   66, 0xFB }, 
  {   67, 0x00 }, 
  {   68, 0x38 }, 
  {   69, 0x67 }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x40 }, 
  {   81, 0x64 }, 
  {   82, 0x01 }, 
  {   83, 0x00 }, 
  {   84, 0x30 }, 
  {   85, 0x67 }, 
  {   86, 0xFB }, 
  {   87, 0x00 }, 
  {   88, 0x80 }, 
  {   89, 0x2F }, 
  {   90, 0xFB }, 
  {   91, 0x00 }, 
  {   92, 0x80 }, 
  {   93, 0x33 }, 
  {   94, 0xFB }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x88 }, 
  {  101, 0x10 }, 
  {  102, 0x0B }, 
  {  103, 0x00 }, 
  {  104, 0x38 }, 
  {  105, 0x33 }, 
  {  106, 0xFB }, 
  {  107, 0x00 }, 
  {  108, 0x30 }, 
  {  109, 0x3B }, 
  {  110, 0xFB }, 
  {  111, 0x00 }, 
  {  112, 0x88 }, 
  {  113, 0x10 }, 
  {  114, 0x04 }, 
  {  115, 0x00 }, 
  {  116, 0x20 }, 
  {  117, 0x08 }, 
  {  118, 0x0A }, 
  {  119, 0x00 }, 
  {  120, 0x30 }, 
  {  121, 0x2B }, 
  {  122, 0xFB }, 
  {  123, 0x00 }, 
  {  124, 0x40 }, 
  {  125, 0x78 }, 
  {  126, 0x02 }, 
  {  127, 0x00 }, 
  {    0, 0x9A }, 
  {    8, 0x88 }, 
  {    9, 0x00 }, 
  {   10, 0x0B }, 
  {   11, 0x00 }, 
  {   12, 0x20 }, 
  {   13, 0x08 }, 
  {   14, 0x0A }, 
  {   15, 0x00 }, 
  {   16, 0x30 }, 
  {   17, 0x27 }, 
  {   18, 0xFB }, 
  {   19, 0x00 }, 
  {   20, 0x40 }, 
  {   21, 0x78 }, 
  {   22, 0x02 }, 
  {   23, 0x00 }, 
  {   24, 0x88 }, 
  {   25, 0x00 }, 
  {   26, 0x07 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x38 }, 
  {   37, 0x2F }, 
  {   38, 0xFB }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x37 }, 
  {   42, 0xFB }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x23 }, 
  {   46, 0xFB }, 
  {   47, 0x00 }, 
  {   48, 0x20 }, 
  {   49, 0x08 }, 
  {   50, 0x0A }, 
  {   51, 0x00 }, 
  {   52, 0x40 }, 
  {   53, 0x78 }, 
  {   54, 0x02 }, 
  {   55, 0x00 }, 
  {   56, 0x40 }, 
  {   57, 0x7C }, 
  {   58, 0x02 }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x7C }, 
  {   62, 0x0A }, 
  {   63, 0x00 }, 
  {   64, 0x38 }, 
  {   65, 0x7B }, 
  {   66, 0xFB }, 
  {   67, 0x00 }, 
  {   68, 0x80 }, 
  {   69, 0x8B }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x80 }, 
  {   73, 0x87 }, 
  {   74, 0xFB }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x0C }, 
  {   82, 0x02 }, 
  {   83, 0x00 }, 
  {   84, 0x88 }, 
  {   85, 0x10 }, 
  {   86, 0x03 }, 
  {   87, 0x00 }, 
  {   88, 0x88 }, 
  {   89, 0x00 }, 
  {   90, 0x03 }, 
  {   91, 0x00 }, 
  {   92, 0x30 }, 
  {   93, 0x87 }, 
  {   94, 0xFB }, 
  {   95, 0x00 }, 
  {   96, 0x88 }, 
  {   97, 0x00 }, 
  {   98, 0x01 }, 
  {   99, 0x00 }, 
  {  100, 0x30 }, 
  {  101, 0x8B }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x40 }, 
  {  113, 0x80 }, 
  {  114, 0x03 }, 
  {  115, 0x00 }, 
  {  116, 0x30 }, 
  {  117, 0x83 }, 
  {  118, 0xFB }, 
  {  119, 0x00 }, 
  {  120, 0x80 }, 
  {  121, 0x5B }, 
  {  122, 0xFB }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0x9B }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x88 }, 
  {   13, 0x0C }, 
  {   14, 0x18 }, 
  {   15, 0x00 }, 
  {   16, 0x31 }, 
  {   17, 0x07 }, 
  {   18, 0xFB }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x83 }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x18 }, 
  {   25, 0xEC }, 
  {   26, 0x02 }, 
  {   27, 0x00 }, 
  {   28, 0x80 }, 
  {   29, 0xF7 }, 
  {   30, 0xFB }, 
  {   31, 0x00 }, 
  {   32, 0x80 }, 
  {   33, 0xFB }, 
  {   34, 0xFB }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x88 }, 
  {   41, 0x0C }, 
  {   42, 0x0B }, 
  {   43, 0x00 }, 
  {   44, 0x88 }, 
  {   45, 0x0C }, 
  {   46, 0x05 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x90 }, 
  {   53, 0x78 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x30 }, 
  {   57, 0x27 }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x23 }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x00 }, 
  {   66, 0x14 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x90 }, 
  {   73, 0x78 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x30 }, 
  {   77, 0x1F }, 
  {   78, 0xFB }, 
  {   79, 0x00 }, 
  {   80, 0x30 }, 
  {   81, 0x1B }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x88 }, 
  {   85, 0x00 }, 
  {   86, 0x0F }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x90 }, 
  {   97, 0x78 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x30 }, 
  {  101, 0x17 }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x30 }, 
  {  105, 0x13 }, 
  {  106, 0xFB }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x00 }, 
  {  110, 0x09 }, 
  {  111, 0x00 }, 
  {  112, 0x31 }, 
  {  113, 0x0B }, 
  {  114, 0xFB }, 
  {  115, 0x00 }, 
  {  116, 0x30 }, 
  {  117, 0x83 }, 
  {  118, 0xFB }, 
  {  119, 0x00 }, 
  {  120, 0x18 }, 
  {  121, 0xEC }, 
  {  122, 0x02 }, 
  {  123, 0x00 }, 
  {  124, 0x80 }, 
  {  125, 0xFF }, 
  {  126, 0xFB }, 
  {  127, 0x00 }, 
  {    0, 0x9C }, 
  {    8, 0x81 }, 
  {    9, 0x03 }, 
  {   10, 0xFB }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x88 }, 
  {   17, 0x13 }, 
  {   18, 0xF3 }, 
  {   19, 0x00 }, 
  {   20, 0x88 }, 
  {   21, 0x13 }, 
  {   22, 0xED }, 
  {   23, 0x00 }, 
  {   24, 0x88 }, 
  {   25, 0x03 }, 
  {   26, 0xE8 }, 
  {   27, 0x00 }, 
  {   28, 0x40 }, 
  {   29, 0x2C }, 
  {   30, 0x02 }, 
  {   31, 0x00 }, 
  {   32, 0x90 }, 
  {   33, 0xF8 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x38 }, 
  {   37, 0x83 }, 
  {   38, 0xFB }, 
  {   39, 0x00 }, 
  {   40, 0x90 }, 
  {   41, 0x78 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x2B }, 
  {   46, 0xFB }, 
  {   47, 0x00 }, 
  {   48, 0x40 }, 
  {   49, 0x30 }, 
  {   50, 0x02 }, 
  {   51, 0x00 }, 
  {   52, 0x20 }, 
  {   53, 0x08 }, 
  {   54, 0x0B }, 
  {   55, 0x00 }, 
  {   56, 0x20 }, 
  {   57, 0x08 }, 
  {   58, 0x0C }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x00 }, 
  {   62, 0x0B }, 
  {   63, 0x00 }, 
  {   64, 0x38 }, 
  {   65, 0x04 }, 
  {   66, 0x0C }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x30 }, 
  {   73, 0x08 }, 
  {   74, 0x0C }, 
  {   75, 0x00 }, 
  {   76, 0x20 }, 
  {   77, 0x18 }, 
  {   78, 0x0D }, 
  {   79, 0x00 }, 
  {   80, 0x38 }, 
  {   81, 0x30 }, 
  {   82, 0x0D }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x30 }, 
  {   89, 0x0C }, 
  {   90, 0x0C }, 
  {   91, 0x00 }, 
  {   92, 0x20 }, 
  {   93, 0x18 }, 
  {   94, 0x0D }, 
  {   95, 0x00 }, 
  {   96, 0x38 }, 
  {   97, 0x30 }, 
  {   98, 0x0D }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x20 }, 
  {  109, 0x0C }, 
  {  110, 0x0D }, 
  {  111, 0x00 }, 
  {  112, 0x30 }, 
  {  113, 0x2C }, 
  {  114, 0x0D }, 
  {  115, 0x00 }, 
  {  116, 0x90 }, 
  {  117, 0xF8 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x20 }, 
  {  125, 0x04 }, 
  {  126, 0x0D }, 
  {  127, 0x00 }, 
  {    0, 0x9D }, 
  {    8, 0x30 }, 
  {    9, 0x7F }, 
  {   10, 0xFB }, 
  {   11, 0x00 }, 
  {   12, 0x30 }, 
  {   13, 0x54 }, 
  {   14, 0x0D }, 
  {   15, 0x00 }, 
  {   16, 0x30 }, 
  {   17, 0x57 }, 
  {   18, 0xFB }, 
  {   19, 0x00 }, 
  {   20, 0x88 }, 
  {   21, 0x18 }, 
  {   22, 0x03 }, 
  {   23, 0x00 }, 
  {   24, 0x20 }, 
  {   25, 0x04 }, 
  {   26, 0x0F }, 
  {   27, 0x00 }, 
  {   28, 0x20 }, 
  {   29, 0xEC }, 
  {   30, 0x0E }, 
  {   31, 0x00 }, 
  {   32, 0x88 }, 
  {   33, 0x00 }, 
  {   34, 0x03 }, 
  {   35, 0x00 }, 
  {   36, 0x20 }, 
  {   37, 0x04 }, 
  {   38, 0x0E }, 
  {   39, 0x00 }, 
  {   40, 0x20 }, 
  {   41, 0xEC }, 
  {   42, 0x0F }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x30 }, 
  {   49, 0x60 }, 
  {   50, 0x11 }, 
  {   51, 0x00 }, 
  {   52, 0x80 }, 
  {   53, 0x54 }, 
  {   54, 0x0E }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x0C }, 
  {   66, 0x03 }, 
}; // first_reg_value miniDSP_D_first_reg_values_p5
first_reg_value miniDSP_D_first_reg_values_p6[] = {
  {   67, 0x00 }, 
  {   68, 0x30 }, 
  {   69, 0x40 }, 
  {   70, 0x11 }, 
  {   71, 0x00 }, 
  {   72, 0x38 }, 
  {   73, 0x3C }, 
  {   74, 0x0E }, 
  {   75, 0x00 }, 
  {   76, 0x88 }, 
  {   77, 0x00 }, 
  {   78, 0x03 }, 
  {   79, 0x00 }, 
  {   80, 0x30 }, 
  {   81, 0x48 }, 
  {   82, 0x11 }, 
  {   83, 0x00 }, 
  {   84, 0x38 }, 
  {   85, 0x44 }, 
  {   86, 0x0E }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x30 }, 
  {   93, 0x60 }, 
  {   94, 0x13 }, 
  {   95, 0x00 }, 
  {   96, 0x20 }, 
  {   97, 0x00 }, 
  {   98, 0x10 }, 
  {   99, 0x00 }, 
  {  100, 0x41 }, 
  {  101, 0x0C }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x80 }, 
  {  105, 0x54 }, 
  {  106, 0x0F }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x88 }, 
  {  117, 0x0C }, 
  {  118, 0x03 }, 
  {  119, 0x00 }, 
  {  120, 0x30 }, 
  {  121, 0x48 }, 
  {  122, 0x13 }, 
  {  123, 0x00 }, 
  {  124, 0x38 }, 
  {  125, 0x44 }, 
  {  126, 0x0F }, 
  {  127, 0x00 }, 
  {    0, 0x9E }, 
  {    8, 0x88 }, 
  {    9, 0x00 }, 
  {   10, 0x03 }, 
  {   11, 0x00 }, 
  {   12, 0x30 }, 
  {   13, 0x40 }, 
  {   14, 0x13 }, 
  {   15, 0x00 }, 
  {   16, 0x38 }, 
  {   17, 0x3C }, 
  {   18, 0x0F }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x20 }, 
  {   29, 0x00 }, 
  {   30, 0x12 }, 
  {   31, 0x00 }, 
  {   32, 0x41 }, 
  {   33, 0x10 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x31 }, 
  {   37, 0x0C }, 
  {   38, 0x05 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x49 }, 
  {   45, 0x10 }, 
  {   46, 0x08 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x20 }, 
  {   57, 0x20 }, 
  {   58, 0x07 }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x5C }, 
  {   62, 0x07 }, 
  {   63, 0x00 }, 
  {   64, 0x30 }, 
  {   65, 0x5C }, 
  {   66, 0x06 }, 
  {   67, 0x00 }, 
  {   68, 0x35 }, 
  {   69, 0xF7 }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x28 }, 
  {   73, 0xF0 }, 
  {   74, 0x16 }, 
  {   75, 0x00 }, 
  {   76, 0x28 }, 
  {   77, 0x09 }, 
  {   78, 0x17 }, 
  {   79, 0x00 }, 
  {   80, 0x28 }, 
  {   81, 0xD9 }, 
  {   82, 0x34 }, 
  {   83, 0x00 }, 
  {   84, 0x30 }, 
  {   85, 0x54 }, 
  {   86, 0x16 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x50 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0x54 }, 
  {   98, 0x3E }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x20 }, 
  {  105, 0x04 }, 
  {  106, 0x16 }, 
  {  107, 0x00 }, 
  {  108, 0x45 }, 
  {  109, 0xC8 }, 
  {  110, 0x01 }, 
  {  111, 0x00 }, 
  {  112, 0x35 }, 
  {  113, 0xC8 }, 
  {  114, 0x3E }, 
  {  115, 0x00 }, 
  {  116, 0x35 }, 
  {  117, 0xD9 }, 
  {  118, 0x1F }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x20 }, 
  {  125, 0x31 }, 
  {  126, 0x19 }, 
  {  127, 0x00 }, 
  {    0, 0x9F }, 
  {    8, 0x3D }, 
  {    9, 0xDD }, 
  {   10, 0x19 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x30 }, 
  {   17, 0x55 }, 
  {   18, 0x17 }, 
  {   19, 0x00 }, 
  {   20, 0x20 }, 
  {   21, 0x01 }, 
  {   22, 0x1E }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x45 }, 
  {   29, 0xCC }, 
  {   30, 0x01 }, 
  {   31, 0x00 }, 
  {   32, 0x35 }, 
  {   33, 0xCD }, 
  {   34, 0x17 }, 
  {   35, 0x00 }, 
  {   36, 0x35 }, 
  {   37, 0xD9 }, 
  {   38, 0x21 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x20 }, 
  {   45, 0x01 }, 
  {   46, 0x1A }, 
  {   47, 0x00 }, 
  {   48, 0x3D }, 
  {   49, 0xDD }, 
  {   50, 0x1A }, 
  {   51, 0x00 }, 
  {   52, 0x30 }, 
  {   53, 0x54 }, 
  {   54, 0x3E }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x20 }, 
  {   61, 0x01 }, 
  {   62, 0x20 }, 
  {   63, 0x00 }, 
  {   64, 0x45 }, 
  {   65, 0xC8 }, 
  {   66, 0x01 }, 
  {   67, 0x00 }, 
  {   68, 0x35 }, 
  {   69, 0xC8 }, 
  {   70, 0x3E }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x48 }, 
  {   77, 0x04 }, 
  {   78, 0x0C }, 
  {   79, 0x00 }, 
  {   80, 0x35 }, 
  {   81, 0xD9 }, 
  {   82, 0x23 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x01 }, 
  {   90, 0x1B }, 
  {   91, 0x00 }, 
  {   92, 0x3D }, 
  {   93, 0xDD }, 
  {   94, 0x1B }, 
  {   95, 0x00 }, 
  {   96, 0x80 }, 
  {   97, 0x51 }, 
  {   98, 0x34 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x20 }, 
  {  105, 0x01 }, 
  {  106, 0x22 }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x0C }, 
  {  110, 0x03 }, 
  {  111, 0x00 }, 
  {  112, 0x30 }, 
  {  113, 0x5D }, 
  {  114, 0x34 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x88 }, 
  {  121, 0x00 }, 
  {  122, 0x03 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xA0 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x20 }, 
  {   17, 0x01 }, 
  {   18, 0x22 }, 
  {   19, 0x00 }, 
  {   20, 0x35 }, 
  {   21, 0xD1 }, 
  {   22, 0x29 }, 
  {   23, 0x00 }, 
  {   24, 0x3D }, 
  {   25, 0xD5 }, 
  {   26, 0x1E }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x36 }, 
  {   33, 0x09 }, 
  {   34, 0x25 }, 
  {   35, 0x00 }, 
  {   36, 0x20 }, 
  {   37, 0x01 }, 
  {   38, 0x28 }, 
  {   39, 0x00 }, 
  {   40, 0x4D }, 
  {   41, 0xA0 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x38 }, 
  {   45, 0x5D }, 
  {   46, 0x25 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x80 }, 
  {   53, 0x51 }, 
  {   54, 0x28 }, 
  {   55, 0x00 }, 
  {   56, 0x20 }, 
  {   57, 0x01 }, 
  {   58, 0x47 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x0C }, 
  {   66, 0x02 }, 
  {   67, 0x00 }, 
  {   68, 0x30 }, 
  {   69, 0x55 }, 
  {   70, 0x47 }, 
  {   71, 0x00 }, 
  {   72, 0x88 }, 
  {   73, 0x00 }, 
  {   74, 0x02 }, 
  {   75, 0x00 }, 
  {   76, 0x30 }, 
  {   77, 0x55 }, 
  {   78, 0x28 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x05 }, 
  {   90, 0x24 }, 
  {   91, 0x00 }, 
  {   92, 0x35 }, 
  {   93, 0xD1 }, 
  {   94, 0x2B }, 
  {   95, 0x00 }, 
  {   96, 0x3D }, 
  {   97, 0xD5 }, 
  {   98, 0x20 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x36 }, 
  {  105, 0x09 }, 
  {  106, 0x27 }, 
  {  107, 0x00 }, 
  {  108, 0x20 }, 
  {  109, 0x01 }, 
  {  110, 0x2A }, 
  {  111, 0x00 }, 
  {  112, 0x4D }, 
  {  113, 0xA0 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x38 }, 
  {  117, 0x5D }, 
  {  118, 0x27 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x80 }, 
  {  125, 0x51 }, 
  {  126, 0x2A }, 
  {  127, 0x00 }, 
  {    0, 0xA1 }, 
  {    8, 0x20 }, 
  {    9, 0x01 }, 
  {   10, 0x47 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x88 }, 
  {   17, 0x0C }, 
  {   18, 0x02 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x55 }, 
  {   22, 0x47 }, 
  {   23, 0x00 }, 
  {   24, 0x88 }, 
  {   25, 0x00 }, 
  {   26, 0x02 }, 
  {   27, 0x00 }, 
  {   28, 0x30 }, 
  {   29, 0x55 }, 
  {   30, 0x2A }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x20 }, 
  {   41, 0x05 }, 
  {   42, 0x26 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x55 }, 
  {   46, 0x36 }, 
  {   47, 0x00 }, 
  {   48, 0x3D }, 
  {   49, 0xA3 }, 
  {   50, 0xFB }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x85 }, 
  {   57, 0xFF }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x28 }, 
  {   61, 0x05 }, 
  {   62, 0x35 }, 
  {   63, 0x00 }, 
  {   64, 0x48 }, 
  {   65, 0x58 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x88 }, 
  {   69, 0x08 }, 
  {   70, 0x06 }, 
  {   71, 0x00 }, 
  {   72, 0x30 }, 
  {   73, 0x55 }, 
  {   74, 0x25 }, 
  {   75, 0x00 }, 
  {   76, 0x30 }, 
  {   77, 0x55 }, 
  {   78, 0x27 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x20 }, 
  {   85, 0x05 }, 
  {   86, 0x24 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x05 }, 
  {   90, 0x26 }, 
  {   91, 0x00 }, 
  {   92, 0x88 }, 
  {   93, 0x00 }, 
  {   94, 0x06 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x20 }, 
  {  101, 0x01 }, 
  {  102, 0x35 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x30 }, 
  {  121, 0x55 }, 
  {  122, 0x38 }, 
  {  123, 0x00 }, 
  {  124, 0x86 }, 
  {  125, 0x03 }, 
  {  126, 0xFB }, 
  {  127, 0x00 }, 
  {    0, 0xA2 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x3D }, 
  {   13, 0xAB }, 
  {   14, 0xFB }, 
  {   15, 0x00 }, 
  {   16, 0x88 }, 
  {   17, 0x04 }, 
  {   18, 0x05 }, 
  {   19, 0x00 }, 
  {   20, 0x20 }, 
  {   21, 0x05 }, 
  {   22, 0x37 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x88 }, 
  {   37, 0x00 }, 
  {   38, 0x05 }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x55 }, 
  {   42, 0x28 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x55 }, 
  {   46, 0x2A }, 
  {   47, 0x00 }, 
  {   48, 0x20 }, 
  {   49, 0x05 }, 
  {   50, 0x37 }, 
  {   51, 0x00 }, 
  {   52, 0x20 }, 
  {   53, 0x05 }, 
  {   54, 0x24 }, 
  {   55, 0x00 }, 
  {   56, 0x20 }, 
  {   57, 0x05 }, 
  {   58, 0x26 }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x55 }, 
  {   62, 0x24 }, 
  {   63, 0x00 }, 
  {   64, 0x85 }, 
  {   65, 0xAD }, 
  {   66, 0x34 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x88 }, 
  {   77, 0x0C }, 
  {   78, 0x03 }, 
  {   79, 0x00 }, 
  {   80, 0x30 }, 
  {   81, 0x55 }, 
  {   82, 0x34 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x88 }, 
  {   89, 0x00 }, 
  {   90, 0x03 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x20 }, 
  {  105, 0x05 }, 
  {  106, 0x24 }, 
  {  107, 0x00 }, 
  {  108, 0x30 }, 
  {  109, 0x55 }, 
  {  110, 0x26 }, 
  {  111, 0x00 }, 
  {  112, 0x85 }, 
  {  113, 0xAD }, 
  {  114, 0x34 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x88 }, 
  {  125, 0x0C }, 
  {  126, 0x03 }, 
  {  127, 0x00 }, 
  {    0, 0xA3 }, 
  {    8, 0x30 }, 
  {    9, 0x55 }, 
  {   10, 0x34 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x88 }, 
  {   17, 0x00 }, 
  {   18, 0x03 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x20 }, 
  {   33, 0x05 }, 
  {   34, 0x26 }, 
  {   35, 0x00 }, 
  {   36, 0x30 }, 
  {   37, 0x55 }, 
  {   38, 0x1E }, 
  {   39, 0x00 }, 
  {   40, 0x85 }, 
  {   41, 0xFB }, 
  {   42, 0xFB }, 
  {   43, 0x00 }, 
  {   44, 0x36 }, 
  {   45, 0x07 }, 
  {   46, 0xFB }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x88 }, 
  {   53, 0x0C }, 
  {   54, 0x04 }, 
  {   55, 0x00 }, 
  {   56, 0x30 }, 
  {   57, 0x55 }, 
  {   58, 0x3A }, 
  {   59, 0x00 }, 
  {   60, 0x3D }, 
  {   61, 0xBF }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x88 }, 
  {   69, 0x00 }, 
  {   70, 0x04 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x28 }, 
  {   89, 0x05 }, 
  {   90, 0x39 }, 
  {   91, 0x00 }, 
  {   92, 0x88 }, 
  {   93, 0x18 }, 
  {   94, 0x04 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x00 }, 
  {  110, 0x04 }, 
  {  111, 0x00 }, 
  {  112, 0x35 }, 
  {  113, 0xBF }, 
  {  114, 0xFB }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x28 }, 
  {  125, 0x05 }, 
  {  126, 0x39 }, 
  {  127, 0x00 }, 
  {    0, 0xA4 }, 
  {    8, 0x35 }, 
  {    9, 0xA5 }, 
  {   10, 0x20 }, 
  {   11, 0x00 }, 
  {   12, 0x86 }, 
  {   13, 0x0D }, 
  {   14, 0x22 }, 
  {   15, 0x00 }, 
  {   16, 0x36 }, 
  {   17, 0x07 }, 
  {   18, 0xFB }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x88 }, 
  {   25, 0x0C }, 
  {   26, 0x04 }, 
  {   27, 0x00 }, 
  {   28, 0x30 }, 
  {   29, 0x55 }, 
  {   30, 0x3C }, 
  {   31, 0x00 }, 
  {   32, 0x3D }, 
  {   33, 0xBF }, 
  {   34, 0xFB }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x88 }, 
  {   41, 0x00 }, 
  {   42, 0x04 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x28 }, 
  {   61, 0x05 }, 
  {   62, 0x3B }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x18 }, 
  {   66, 0x04 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x00 }, 
  {   82, 0x04 }, 
  {   83, 0x00 }, 
  {   84, 0x35 }, 
  {   85, 0xBF }, 
  {   86, 0xFB }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x28 }, 
  {   97, 0x05 }, 
  {   98, 0x3B }, 
  {   99, 0x00 }, 
  {  100, 0x35 }, 
  {  101, 0x99 }, 
  {  102, 0x1E }, 
  {  103, 0x00 }, 
  {  104, 0x86 }, 
  {  105, 0x0D }, 
  {  106, 0x24 }, 
  {  107, 0x00 }, 
  {  108, 0x36 }, 
  {  109, 0x07 }, 
  {  110, 0xFB }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x88 }, 
  {  117, 0x0C }, 
  {  118, 0x04 }, 
  {  119, 0x00 }, 
  {  120, 0x30 }, 
  {  121, 0x55 }, 
  {  122, 0x3E }, 
  {  123, 0x00 }, 
  {  124, 0x3D }, 
  {  125, 0xBF }, 
  {  126, 0xFB }, 
  {  127, 0x00 }, 
  {    0, 0xA5 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x88 }, 
  {   13, 0x00 }, 
  {   14, 0x04 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x28 }, 
  {   33, 0x05 }, 
  {   34, 0x3D }, 
  {   35, 0x00 }, 
  {   36, 0x88 }, 
  {   37, 0x18 }, 
  {   38, 0x04 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x88 }, 
  {   53, 0x00 }, 
  {   54, 0x04 }, 
  {   55, 0x00 }, 
  {   56, 0x35 }, 
  {   57, 0xBF }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x28 }, 
  {   69, 0x05 }, 
  {   70, 0x3D }, 
  {   71, 0x00 }, 
  {   72, 0x35 }, 
  {   73, 0xA5 }, 
  {   74, 0x20 }, 
  {   75, 0x00 }, 
  {   76, 0x3D }, 
  {   77, 0xB1 }, 
  {   78, 0x22 }, 
  {   79, 0x00 }, 
  {   80, 0x86 }, 
  {   81, 0x11 }, 
  {   82, 0x26 }, 
  {   83, 0x00 }, 
  {   84, 0x36 }, 
  {   85, 0x07 }, 
  {   86, 0xFB }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x88 }, 
  {   93, 0x0C }, 
  {   94, 0x04 }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0x55 }, 
  {   98, 0x40 }, 
  {   99, 0x00 }, 
  {  100, 0x3D }, 
  {  101, 0xBF }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x00 }, 
}; // first_reg_value miniDSP_D_first_reg_values_p6
first_reg_value miniDSP_D_first_reg_values_p7[] = {
  {  110, 0x04 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xA6 }, 
  {    8, 0x28 }, 
  {    9, 0x05 }, 
  {   10, 0x3F }, 
  {   11, 0x00 }, 
  {   12, 0x88 }, 
  {   13, 0x18 }, 
  {   14, 0x04 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x88 }, 
  {   29, 0x00 }, 
  {   30, 0x04 }, 
  {   31, 0x00 }, 
  {   32, 0x35 }, 
  {   33, 0xBF }, 
  {   34, 0xFB }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x28 }, 
  {   45, 0x05 }, 
  {   46, 0x3F }, 
  {   47, 0x00 }, 
  {   48, 0x35 }, 
  {   49, 0x99 }, 
  {   50, 0x20 }, 
  {   51, 0x00 }, 
  {   52, 0x86 }, 
  {   53, 0x0D }, 
  {   54, 0x26 }, 
  {   55, 0x00 }, 
  {   56, 0x36 }, 
  {   57, 0x07 }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x0C }, 
  {   66, 0x04 }, 
  {   67, 0x00 }, 
  {   68, 0x30 }, 
  {   69, 0x55 }, 
  {   70, 0x42 }, 
  {   71, 0x00 }, 
  {   72, 0x3D }, 
  {   73, 0xBF }, 
  {   74, 0xFB }, 
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x00 }, 
  {   82, 0x04 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x28 }, 
  {  101, 0x05 }, 
  {  102, 0x41 }, 
  {  103, 0x00 }, 
  {  104, 0x88 }, 
  {  105, 0x18 }, 
  {  106, 0x04 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x88 }, 
  {  121, 0x00 }, 
  {  122, 0x04 }, 
  {  123, 0x00 }, 
  {  124, 0x35 }, 
  {  125, 0xBF }, 
  {  126, 0xFB }, 
  {  127, 0x00 }, 
  {    0, 0xA7 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x28 }, 
  {   17, 0x05 }, 
  {   18, 0x41 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x5B }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x20 }, 
  {   33, 0x01 }, 
  {   34, 0x52 }, 
  {   35, 0x00 }, 
  {   36, 0x46 }, 
  {   37, 0x4C }, 
  {   38, 0x02 }, 
  {   39, 0x00 }, 
  {   40, 0x46 }, 
  {   41, 0x50 }, 
  {   42, 0x02 }, 
  {   43, 0x00 }, 
  {   44, 0x36 }, 
  {   45, 0x4F }, 
  {   46, 0xFB }, 
  {   47, 0x00 }, 
  {   48, 0x36 }, 
  {   49, 0x53 }, 
  {   50, 0xFB }, 
  {   51, 0x00 }, 
  {   52, 0x18 }, 
  {   53, 0xF0 }, 
  {   54, 0x02 }, 
  {   55, 0x00 }, 
  {   56, 0x18 }, 
  {   57, 0xEC }, 
  {   58, 0x03 }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x5D }, 
  {   62, 0x52 }, 
  {   63, 0x00 }, 
  {   64, 0x90 }, 
  {   65, 0x7C }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x90 }, 
  {   69, 0x78 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x88 }, 
  {   73, 0x80 }, 
  {   74, 0x0E }, 
  {   75, 0x00 }, 
  {   76, 0x90 }, 
  {   77, 0xF8 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x90 }, 
  {   81, 0xFC }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x20 }, 
  {   85, 0x01 }, 
  {   86, 0x52 }, 
  {   87, 0x00 }, 
  {   88, 0x36 }, 
  {   89, 0x4F }, 
  {   90, 0xFB }, 
  {   91, 0x00 }, 
  {   92, 0x3E }, 
  {   93, 0x33 }, 
  {   94, 0xFB }, 
  {   95, 0x00 }, 
  {   96, 0x86 }, 
  {   97, 0x5F }, 
  {   98, 0xFB }, 
  {   99, 0x00 }, 
  {  100, 0x36 }, 
  {  101, 0x2F }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x46 }, 
  {  105, 0x4C }, 
  {  106, 0x02 }, 
  {  107, 0x00 }, 
  {  108, 0x3E }, 
  {  109, 0x53 }, 
  {  110, 0xFB }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x46 }, 
  {  121, 0x50 }, 
  {  122, 0x02 }, 
  {  123, 0x00 }, 
  {  124, 0x88 }, 
  {  125, 0x07 }, 
  {  126, 0xEB }, 
  {  127, 0x00 }, 
  {    0, 0xA8 }, 
  {    8, 0x88 }, 
  {    9, 0x00 }, 
  {   10, 0x21 }, 
  {   11, 0x00 }, 
  {   12, 0x39 }, 
  {   13, 0x20 }, 
  {   14, 0x16 }, 
  {   15, 0x00 }, 
  {   16, 0x39 }, 
  {   17, 0x24 }, 
  {   18, 0x17 }, 
  {   19, 0x00 }, 
  {   20, 0x39 }, 
  {   21, 0x28 }, 
  {   22, 0x18 }, 
  {   23, 0x00 }, 
  {   24, 0x39 }, 
  {   25, 0x2C }, 
  {   26, 0x19 }, 
  {   27, 0x00 }, 
  {   28, 0x39 }, 
  {   29, 0x30 }, 
  {   30, 0x1A }, 
  {   31, 0x00 }, 
  {   32, 0x39 }, 
  {   33, 0x34 }, 
  {   34, 0x1B }, 
  {   35, 0x00 }, 
  {   36, 0x39 }, 
  {   37, 0x38 }, 
  {   38, 0x1C }, 
  {   39, 0x00 }, 
  {   40, 0x39 }, 
  {   41, 0x3C }, 
  {   42, 0x1D }, 
  {   43, 0x00 }, 
  {   44, 0x39 }, 
  {   45, 0x40 }, 
  {   46, 0x1E }, 
  {   47, 0x00 }, 
  {   48, 0x39 }, 
  {   49, 0x44 }, 
  {   50, 0x1F }, 
  {   51, 0x00 }, 
  {   52, 0x39 }, 
  {   53, 0x48 }, 
  {   54, 0x20 }, 
  {   55, 0x00 }, 
  {   56, 0x39 }, 
  {   57, 0x4C }, 
  {   58, 0x21 }, 
  {   59, 0x00 }, 
  {   60, 0x39 }, 
  {   61, 0x50 }, 
  {   62, 0x22 }, 
  {   63, 0x00 }, 
  {   64, 0x39 }, 
  {   65, 0x54 }, 
  {   66, 0x23 }, 
  {   67, 0x00 }, 
  {   68, 0x39 }, 
  {   69, 0x58 }, 
  {   70, 0x24 }, 
  {   71, 0x00 }, 
  {   72, 0x39 }, 
  {   73, 0x5C }, 
  {   74, 0x25 }, 
  {   75, 0x00 }, 
  {   76, 0x39 }, 
  {   77, 0x68 }, 
  {   78, 0x26 }, 
  {   79, 0x00 }, 
  {   80, 0x39 }, 
  {   81, 0x6C }, 
  {   82, 0x27 }, 
  {   83, 0x00 }, 
  {   84, 0x39 }, 
  {   85, 0x70 }, 
  {   86, 0x28 }, 
  {   87, 0x00 }, 
  {   88, 0x39 }, 
  {   89, 0x74 }, 
  {   90, 0x29 }, 
  {   91, 0x00 }, 
  {   92, 0x39 }, 
  {   93, 0x78 }, 
  {   94, 0x2A }, 
  {   95, 0x00 }, 
  {   96, 0x39 }, 
  {   97, 0x7C }, 
  {   98, 0x2B }, 
  {   99, 0x00 }, 
  {  100, 0x39 }, 
  {  101, 0x80 }, 
  {  102, 0x2C }, 
  {  103, 0x00 }, 
  {  104, 0x39 }, 
  {  105, 0x84 }, 
  {  106, 0x2D }, 
  {  107, 0x00 }, 
  {  108, 0x39 }, 
  {  109, 0x88 }, 
  {  110, 0x2E }, 
  {  111, 0x00 }, 
  {  112, 0x39 }, 
  {  113, 0x8C }, 
  {  114, 0x2F }, 
  {  115, 0x00 }, 
  {  116, 0x39 }, 
  {  117, 0x90 }, 
  {  118, 0x30 }, 
  {  119, 0x00 }, 
  {  120, 0x39 }, 
  {  121, 0x94 }, 
  {  122, 0x31 }, 
  {  123, 0x00 }, 
  {  124, 0x39 }, 
  {  125, 0x98 }, 
  {  126, 0x32 }, 
  {  127, 0x00 }, 
  {    0, 0xA9 }, 
  {    8, 0x39 }, 
  {    9, 0x9C }, 
  {   10, 0x33 }, 
  {   11, 0x00 }, 
  {   12, 0x39 }, 
  {   13, 0xA0 }, 
  {   14, 0x34 }, 
  {   15, 0x00 }, 
  {   16, 0x39 }, 
  {   17, 0xA4 }, 
  {   18, 0x35 }, 
  {   19, 0x00 }, 
  {   20, 0x89 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x30 }, 
  {   29, 0x5D }, 
  {   30, 0x17 }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x48 }, 
  {   37, 0x5C }, 
  {   38, 0x36 }, 
  {   39, 0x00 }, 
  {   40, 0x38 }, 
  {   41, 0x51 }, 
  {   42, 0x52 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x54 }, 
  {   46, 0x3E }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x20 }, 
  {   53, 0x29 }, 
  {   54, 0x18 }, 
  {   55, 0x00 }, 
  {   56, 0x45 }, 
  {   57, 0xC8 }, 
  {   58, 0x01 }, 
  {   59, 0x00 }, 
  {   60, 0x35 }, 
  {   61, 0xC8 }, 
  {   62, 0x3E }, 
  {   63, 0x00 }, 
  {   64, 0x35 }, 
  {   65, 0xD1 }, 
  {   66, 0x1D }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x20 }, 
  {   73, 0x31 }, 
  {   74, 0x19 }, 
  {   75, 0x00 }, 
  {   76, 0x3D }, 
  {   77, 0xD5 }, 
  {   78, 0x19 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x01 }, 
  {   90, 0x1C }, 
  {   91, 0x00 }, 
  {   92, 0x20 }, 
  {   93, 0x01 }, 
  {   94, 0x48 }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0x55 }, 
  {   98, 0x48 }, 
  {   99, 0x00 }, 
  {  100, 0x30 }, 
  {  101, 0x5F }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x28 }, 
  {  109, 0xC5 }, 
  {  110, 0x48 }, 
  {  111, 0x00 }, 
  {  112, 0x41 }, 
  {  113, 0x18 }, 
  {  114, 0x02 }, 
  {  115, 0x00 }, 
  {  116, 0x35 }, 
  {  117, 0xC7 }, 
  {  118, 0xFB }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xAA }, 
  {    8, 0x28 }, 
  {    9, 0x05 }, 
  {   10, 0x4A }, 
  {   11, 0x00 }, 
  {   12, 0x30 }, 
  {   13, 0x55 }, 
  {   14, 0x48 }, 
  {   15, 0x00 }, 
  {   16, 0x80 }, 
  {   17, 0x5B }, 
  {   18, 0xFB }, 
  {   19, 0x00 }, 
  {   20, 0x31 }, 
  {   21, 0x1B }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x28 }, 
  {   25, 0x01 }, 
  {   26, 0x48 }, 
  {   27, 0x00 }, 
  {   28, 0x88 }, 
  {   29, 0x08 }, 
  {   30, 0x02 }, 
  {   31, 0x00 }, 
  {   32, 0x41 }, 
  {   33, 0x18 }, 
  {   34, 0x01 }, 
  {   35, 0x00 }, 
  {   36, 0x88 }, 
  {   37, 0x00 }, 
  {   38, 0x02 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x30 }, 
  {   49, 0x55 }, 
  {   50, 0x4A }, 
  {   51, 0x00 }, 
  {   52, 0x3D }, 
  {   53, 0xBF }, 
  {   54, 0xFB }, 
  {   55, 0x00 }, 
  {   56, 0x80 }, 
  {   57, 0x5B }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x28 }, 
  {   65, 0x05 }, 
  {   66, 0x4A }, 
  {   67, 0x00 }, 
  {   68, 0x88 }, 
  {   69, 0x07 }, 
  {   70, 0xF1 }, 
  {   71, 0x00 }, 
  {   72, 0x30 }, 
  {   73, 0x55 }, 
  {   74, 0x18 }, 
  {   75, 0x00 }, 
  {   76, 0x60 }, 
  {   77, 0x5D }, 
  {   78, 0x18 }, 
  {   79, 0x00 }, 
  {   80, 0x85 }, 
  {   81, 0xBB }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x28 }, 
  {   85, 0x05 }, 
  {   86, 0x4B }, 
  {   87, 0x00 }, 
  {   88, 0x30 }, 
  {   89, 0x5D }, 
  {   90, 0x4B }, 
  {   91, 0x00 }, 
  {   92, 0x31 }, 
  {   93, 0x1B }, 
  {   94, 0xFB }, 
  {   95, 0x00 }, 
  {   96, 0x88 }, 
  {   97, 0x0C }, 
  {   98, 0x03 }, 
  {   99, 0x00 }, 
  {  100, 0x28 }, 
  {  101, 0x1D }, 
  {  102, 0x4B }, 
  {  103, 0x00 }, 
  {  104, 0x41 }, 
  {  105, 0x18 }, 
  {  106, 0x3B }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x00 }, 
  {  110, 0x03 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x36 }, 
  {  125, 0x1D }, 
  {  126, 0x4B }, 
  {  127, 0x00 }, 
  {    0, 0xAB }, 
  {    8, 0x30 }, 
  {    9, 0x5D }, 
  {   10, 0x39 }, 
  {   11, 0x00 }, 
  {   12, 0x80 }, 
  {   13, 0x5B }, 
  {   14, 0xFB }, 
  {   15, 0x00 }, 
  {   16, 0x41 }, 
  {   17, 0x1C }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x5B }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x88 }, 
  {   29, 0x0C }, 
  {   30, 0x02 }, 
  {   31, 0x00 }, 
  {   32, 0x41 }, 
  {   33, 0x1C }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x88 }, 
  {   37, 0x00 }, 
  {   38, 0x02 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x30 }, 
  {   49, 0x5D }, 
  {   50, 0x3B }, 
  {   51, 0x00 }, 
  {   52, 0x80 }, 
  {   53, 0x5B }, 
  {   54, 0xFB }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x30 }, 
  {   61, 0x5B }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x10 }, 
  {   66, 0x03 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x41 }, 
  {   73, 0x1C }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x88 }, 
  {   77, 0x00 }, 
  {   78, 0x03 }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x30 }, 
  {   93, 0x55 }, 
  {   94, 0x3D }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0x55 }, 
  {   98, 0x3F }, 
  {   99, 0x00 }, 
  {  100, 0x36 }, 
  {  101, 0x21 }, 
  {  102, 0x4B }, 
  {  103, 0x00 }, 
  {  104, 0x88 }, 
  {  105, 0x18 }, 
  {  106, 0x06 }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x18 }, 
  {  110, 0x02 }, 
  {  111, 0x00 }, 
  {  112, 0x41 }, 
  {  113, 0x1C }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x88 }, 
  {  117, 0x00 }, 
  {  118, 0x02 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xAC }, 
  {    8, 0x88 }, 
  {    9, 0x00 }, 
  {   10, 0x04 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x00 }, 
  {   21, 0x00 }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x30 }, 
  {   29, 0x5B }, 
  {   30, 0xFB }, 
  {   31, 0x00 }, 
  {   32, 0x00 }, 
  {   33, 0x00 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x46 }, 
  {   41, 0x4C }, 
  {   42, 0x02 }, 
  {   43, 0x00 }, 
  {   44, 0x46 }, 
  {   45, 0x50 }, 
  {   46, 0x02 }, 
  {   47, 0x00 }, 
  {   48, 0x11 }, 
  {   49, 0xF1 }, 
  {   50, 0x93 }, 
  {   51, 0x00 }, 
  {   52, 0x11 }, 
  {   53, 0xED }, 
  {   54, 0x94 }, 
  {   55, 0x00 }, 
  {   56, 0x90 }, 
  {   57, 0x7C }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x31 }, 
  {   61, 0x1B }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x31 }, 
  {   65, 0x1F }, 
  {   66, 0xFB }, 
  {   67, 0x00 }, 
  {   68, 0x90 }, 
  {   69, 0x78 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x41 }, 
  {   73, 0x18 }, 
  {   74, 0x02 }, 
  {   75, 0x00 }, 
  {   76, 0x41 }, 
  {   77, 0x1C }, 
  {   78, 0x02 }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x80 }, 
  {   82, 0x38 }, 
  {   83, 0x00 }, 
  {   84, 0x90 }, 
  {   85, 0xFC }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x90 }, 
  {   89, 0xF8 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x36 }, 
  {   93, 0x4F }, 
  {   94, 0xFB }, 
  {   95, 0x00 }, 
  {   96, 0x3E }, 
  {   97, 0x2B }, 
  {   98, 0xFB }, 
  {   99, 0x00 }, 
  {  100, 0x86 }, 
  {  101, 0x5B }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x36 }, 
  {  105, 0x27 }, 
  {  106, 0xFB }, 
  {  107, 0x00 }, 
  {  108, 0x46 }, 
  {  109, 0x4C }, 
  {  110, 0x02 }, 
  {  111, 0x00 }, 
  {  112, 0x3E }, 
  {  113, 0x53 }, 
  {  114, 0xFB }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x46 }, 
  {  125, 0x50 }, 
  {  126, 0x02 }, 
  {  127, 0x00 }, 
  {    0, 0xAD }, 
  {    8, 0x88 }, 
  {    9, 0x07 }, 
  {   10, 0xEB }, 
  {   11, 0x00 }, 
  {   12, 0x11 }, 
  {   13, 0xF1 }, 
  {   14, 0x93 }, 
  {   15, 0x00 }, 
  {   16, 0x11 }, 
  {   17, 0xED }, 
  {   18, 0x94 }, 
  {   19, 0x00 }, 
  {   20, 0x90 }, 
  {   21, 0x7C }, 
  {   22, 0x00 }, 
  {   23, 0x00 }, 
  {   24, 0x31 }, 
  {   25, 0x1B }, 
  {   26, 0xFB }, 
  {   27, 0x00 }, 
  {   28, 0x31 }, 
  {   29, 0x1F }, 
  {   30, 0xFB }, 
  {   31, 0x00 }, 
  {   32, 0x90 }, 
  {   33, 0x78 }, 
  {   34, 0x00 }, 
  {   35, 0x00 }, 
  {   36, 0x41 }, 
  {   37, 0x18 }, 
  {   38, 0x02 }, 
  {   39, 0x00 }, 
  {   40, 0x41 }, 
  {   41, 0x1C }, 
  {   42, 0x02 }, 
  {   43, 0x00 }, 
  {   44, 0x88 }, 
  {   45, 0x80 }, 
  {   46, 0x23 }, 
  {   47, 0x00 }, 
  {   48, 0x90 }, 
  {   49, 0xFC }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x90 }, 
  {   53, 0xF8 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x36 }, 
  {   57, 0x4F }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x3E }, 
  {   61, 0x2B }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x86 }, 
  {   65, 0x57 }, 
  {   66, 0xFB }, 
  {   67, 0x00 }, 
  {   68, 0x36 }, 
  {   69, 0x27 }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x46 }, 
  {   73, 0x4C }, 
  {   74, 0x02 }, 
  {   75, 0x00 }, 
  {   76, 0x3E }, 
  {   77, 0x53 }, 
  {   78, 0xFB }, 
  {   79, 0x00 }, 
  {   80, 0x00 }, 
  {   81, 0x00 }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x46 }, 
  {   89, 0x50 }, 
  {   90, 0x02 }, 
  {   91, 0x00 }, 
  {   92, 0x88 }, 
  {   93, 0x07 }, 
  {   94, 0xEB }, 
  {   95, 0x00 }, 
  {   96, 0x11 }, 
  {   97, 0xF1 }, 
  {   98, 0x93 }, 
  {   99, 0x00 }, 
  {  100, 0x11 }, 
  {  101, 0xED }, 
  {  102, 0x94 }, 
  {  103, 0x00 }, 
  {  104, 0x90 }, 
  {  105, 0x7C }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x31 }, 
  {  109, 0x1B }, 
  {  110, 0xFB }, 
  {  111, 0x00 }, 
  {  112, 0x31 }, 
  {  113, 0x1F }, 
  {  114, 0xFB }, 
  {  115, 0x00 }, 
  {  116, 0x90 }, 
  {  117, 0x78 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x41 }, 
  {  121, 0x18 }, 
  {  122, 0x02 }, 
  {  123, 0x00 }, 
  {  124, 0x41 }, 
  {  125, 0x1C }, 
  {  126, 0x02 }, 
  {  127, 0x00 }, 
  {    0, 0xAE }, 
  {    8, 0x88 }, 
  {    9, 0x80 }, 
  {   10, 0x0E }, 
  {   11, 0x00 }, 
  {   12, 0x90 }, 
  {   13, 0xFC }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x90 }, 
  {   17, 0xF8 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x11 }, 
  {   21, 0xF1 }, 
  {   22, 0x92 }, 
  {   23, 0x00 }, 
  {   24, 0x11 }, 
  {   25, 0xED }, 
  {   26, 0x91 }, 
  {   27, 0x00 }, 
  {   28, 0x90 }, 
  {   29, 0x7C }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
}; // first_reg_value miniDSP_D_first_reg_values_p7
first_reg_value miniDSP_D_first_reg_values_p8[] = {
  {   32, 0x31 }, 
  {   33, 0x1B }, 
  {   34, 0xFB }, 
  {   35, 0x00 }, 
  {   36, 0x31 }, 
  {   37, 0x1F }, 
  {   38, 0xFB }, 
  {   39, 0x00 }, 
  {   40, 0x90 }, 
  {   41, 0x78 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x41 }, 
  {   45, 0x18 }, 
  {   46, 0x02 }, 
  {   47, 0x00 }, 
  {   48, 0x41 }, 
  {   49, 0x1C }, 
  {   50, 0x02 }, 
  {   51, 0x00 }, 
  {   52, 0x88 }, 
  {   53, 0x80 }, 
  {   54, 0x03 }, 
  {   55, 0x00 }, 
  {   56, 0x90 }, 
  {   57, 0xFC }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x90 }, 
  {   61, 0xF8 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x88 }, 
  {   65, 0x00 }, 
  {   66, 0x53 }, 
  {   67, 0x00 }, 
  {   68, 0x31 }, 
  {   69, 0x18 }, 
  {   70, 0x16 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x49 }, 
  {   77, 0x1C }, 
  {   78, 0x05 }, 
  {   79, 0x00 }, 
  {   80, 0x39 }, 
  {   81, 0x23 }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x31 }, 
  {   89, 0x18 }, 
  {   90, 0x17 }, 
  {   91, 0x00 }, 
  {   92, 0x41 }, 
  {   93, 0x20 }, 
  {   94, 0x02 }, 
  {   95, 0x00 }, 
  {   96, 0x49 }, 
  {   97, 0x1C }, 
  {   98, 0x05 }, 
  {   99, 0x00 }, 
  {  100, 0x39 }, 
  {  101, 0x27 }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x31 }, 
  {  109, 0x18 }, 
  {  110, 0x18 }, 
  {  111, 0x00 }, 
  {  112, 0x41 }, 
  {  113, 0x24 }, 
  {  114, 0x02 }, 
  {  115, 0x00 }, 
  {  116, 0x49 }, 
  {  117, 0x1C }, 
  {  118, 0x05 }, 
  {  119, 0x00 }, 
  {  120, 0x39 }, 
  {  121, 0x2B }, 
  {  122, 0xFB }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xAF }, 
  {    8, 0x31 }, 
  {    9, 0x18 }, 
  {   10, 0x19 }, 
  {   11, 0x00 }, 
  {   12, 0x41 }, 
  {   13, 0x28 }, 
  {   14, 0x02 }, 
  {   15, 0x00 }, 
  {   16, 0x49 }, 
  {   17, 0x1C }, 
  {   18, 0x05 }, 
  {   19, 0x00 }, 
  {   20, 0x39 }, 
  {   21, 0x2F }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x31 }, 
  {   29, 0x18 }, 
  {   30, 0x1A }, 
  {   31, 0x00 }, 
  {   32, 0x41 }, 
  {   33, 0x2C }, 
  {   34, 0x02 }, 
  {   35, 0x00 }, 
  {   36, 0x49 }, 
  {   37, 0x1C }, 
  {   38, 0x05 }, 
  {   39, 0x00 }, 
  {   40, 0x39 }, 
  {   41, 0x33 }, 
  {   42, 0xFB }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x31 }, 
  {   49, 0x18 }, 
  {   50, 0x1B }, 
  {   51, 0x00 }, 
  {   52, 0x41 }, 
  {   53, 0x30 }, 
  {   54, 0x02 }, 
  {   55, 0x00 }, 
  {   56, 0x49 }, 
  {   57, 0x1C }, 
  {   58, 0x05 }, 
  {   59, 0x00 }, 
  {   60, 0x39 }, 
  {   61, 0x37 }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x31 }, 
  {   69, 0x18 }, 
  {   70, 0x1C }, 
  {   71, 0x00 }, 
  {   72, 0x41 }, 
  {   73, 0x34 }, 
  {   74, 0x02 }, 
  {   75, 0x00 }, 
  {   76, 0x49 }, 
  {   77, 0x1C }, 
  {   78, 0x05 }, 
  {   79, 0x00 }, 
  {   80, 0x39 }, 
  {   81, 0x3B }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x31 }, 
  {   89, 0x18 }, 
  {   90, 0x1D }, 
  {   91, 0x00 }, 
  {   92, 0x41 }, 
  {   93, 0x38 }, 
  {   94, 0x02 }, 
  {   95, 0x00 }, 
  {   96, 0x49 }, 
  {   97, 0x1C }, 
  {   98, 0x05 }, 
  {   99, 0x00 }, 
  {  100, 0x39 }, 
  {  101, 0x3F }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x31 }, 
  {  109, 0x18 }, 
  {  110, 0x1E }, 
  {  111, 0x00 }, 
  {  112, 0x41 }, 
  {  113, 0x3C }, 
  {  114, 0x02 }, 
  {  115, 0x00 }, 
  {  116, 0x49 }, 
  {  117, 0x1C }, 
  {  118, 0x05 }, 
  {  119, 0x00 }, 
  {  120, 0x39 }, 
  {  121, 0x43 }, 
  {  122, 0xFB }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xB0 }, 
  {    8, 0x31 }, 
  {    9, 0x18 }, 
  {   10, 0x1F }, 
  {   11, 0x00 }, 
  {   12, 0x41 }, 
  {   13, 0x40 }, 
  {   14, 0x02 }, 
  {   15, 0x00 }, 
  {   16, 0x49 }, 
  {   17, 0x1C }, 
  {   18, 0x05 }, 
  {   19, 0x00 }, 
  {   20, 0x39 }, 
  {   21, 0x47 }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x31 }, 
  {   29, 0x18 }, 
  {   30, 0x20 }, 
  {   31, 0x00 }, 
  {   32, 0x41 }, 
  {   33, 0x44 }, 
  {   34, 0x02 }, 
  {   35, 0x00 }, 
  {   36, 0x49 }, 
  {   37, 0x1C }, 
  {   38, 0x05 }, 
  {   39, 0x00 }, 
  {   40, 0x39 }, 
  {   41, 0x4B }, 
  {   42, 0xFB }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x31 }, 
  {   49, 0x18 }, 
  {   50, 0x21 }, 
  {   51, 0x00 }, 
  {   52, 0x41 }, 
  {   53, 0x48 }, 
  {   54, 0x02 }, 
  {   55, 0x00 }, 
  {   56, 0x49 }, 
  {   57, 0x1C }, 
  {   58, 0x05 }, 
  {   59, 0x00 }, 
  {   60, 0x39 }, 
  {   61, 0x4F }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x31 }, 
  {   69, 0x18 }, 
  {   70, 0x22 }, 
  {   71, 0x00 }, 
  {   72, 0x41 }, 
  {   73, 0x4C }, 
  {   74, 0x02 }, 
  {   75, 0x00 }, 
  {   76, 0x49 }, 
  {   77, 0x1C }, 
  {   78, 0x05 }, 
  {   79, 0x00 }, 
  {   80, 0x39 }, 
  {   81, 0x53 }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x31 }, 
  {   89, 0x18 }, 
  {   90, 0x23 }, 
  {   91, 0x00 }, 
  {   92, 0x41 }, 
  {   93, 0x50 }, 
  {   94, 0x02 }, 
  {   95, 0x00 }, 
  {   96, 0x49 }, 
  {   97, 0x1C }, 
  {   98, 0x05 }, 
  {   99, 0x00 }, 
  {  100, 0x39 }, 
  {  101, 0x57 }, 
  {  102, 0xFB }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x31 }, 
  {  109, 0x18 }, 
  {  110, 0x24 }, 
  {  111, 0x00 }, 
  {  112, 0x41 }, 
  {  113, 0x54 }, 
  {  114, 0x02 }, 
  {  115, 0x00 }, 
  {  116, 0x49 }, 
  {  117, 0x1C }, 
  {  118, 0x05 }, 
  {  119, 0x00 }, 
  {  120, 0x39 }, 
  {  121, 0x5B }, 
  {  122, 0xFB }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xB1 }, 
  {    8, 0x31 }, 
  {    9, 0x18 }, 
  {   10, 0x25 }, 
  {   11, 0x00 }, 
  {   12, 0x41 }, 
  {   13, 0x58 }, 
  {   14, 0x02 }, 
  {   15, 0x00 }, 
  {   16, 0x49 }, 
  {   17, 0x1C }, 
  {   18, 0x05 }, 
  {   19, 0x00 }, 
  {   20, 0x39 }, 
  {   21, 0x5F }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x41 }, 
  {   33, 0x5C }, 
  {   34, 0x02 }, 
  {   35, 0x00 }, 
  {   36, 0x89 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x55 }, 
  {   46, 0x3D }, 
  {   47, 0x00 }, 
  {   48, 0x30 }, 
  {   49, 0x55 }, 
  {   50, 0x3F }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x88 }, 
  {   57, 0x18 }, 
  {   58, 0x0A }, 
  {   59, 0x00 }, 
  {   60, 0x88 }, 
  {   61, 0x18 }, 
  {   62, 0x03 }, 
  {   63, 0x00 }, 
  {   64, 0x30 }, 
  {   65, 0x0B }, 
  {   66, 0xFB }, 
  {   67, 0x00 }, 
  {   68, 0x30 }, 
  {   69, 0x0F }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x88 }, 
  {   73, 0x00 }, 
  {   74, 0x03 }, 
  {   75, 0x00 }, 
  {   76, 0x30 }, 
  {   77, 0x5F }, 
  {   78, 0xFB }, 
  {   79, 0x00 }, 
  {   80, 0x30 }, 
  {   81, 0x13 }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x28 }, 
  {   89, 0x09 }, 
  {   90, 0x4C }, 
  {   91, 0x00 }, 
  {   92, 0x28 }, 
  {   93, 0x09 }, 
  {   94, 0x4D }, 
  {   95, 0x00 }, 
  {   96, 0x88 }, 
  {   97, 0x00 }, 
  {   98, 0x0A }, 
  {   99, 0x00 }, 
  {  100, 0x88 }, 
  {  101, 0x18 }, 
  {  102, 0x03 }, 
  {  103, 0x00 }, 
  {  104, 0x30 }, 
  {  105, 0x17 }, 
  {  106, 0xFB }, 
  {  107, 0x00 }, 
  {  108, 0x30 }, 
  {  109, 0x5F }, 
  {  110, 0xFB }, 
  {  111, 0x00 }, 
  {  112, 0x88 }, 
  {  113, 0x00 }, 
  {  114, 0x03 }, 
  {  115, 0x00 }, 
  {  116, 0x30 }, 
  {  117, 0x17 }, 
  {  118, 0xFB }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xB2 }, 
  {    8, 0x28 }, 
  {    9, 0x09 }, 
  {   10, 0x4C }, 
  {   11, 0x00 }, 
  {   12, 0x28 }, 
  {   13, 0x09 }, 
  {   14, 0x4D }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x5D }, 
  {   22, 0x42 }, 
  {   23, 0x00 }, 
  {   24, 0x30 }, 
  {   25, 0x53 }, 
  {   26, 0xFB }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x88 }, 
  {   33, 0x18 }, 
  {   34, 0x01 }, 
  {   35, 0x00 }, 
  {   36, 0x88 }, 
  {   37, 0x00 }, 
  {   38, 0x01 }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x5D }, 
  {   42, 0x41 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x20 }, 
  {   53, 0x01 }, 
  {   54, 0x54 }, 
  {   55, 0x00 }, 
  {   56, 0x30 }, 
  {   57, 0x5D }, 
  {   58, 0x54 }, 
  {   59, 0x00 }, 
  {   60, 0x35 }, 
  {   61, 0xF3 }, 
  {   62, 0xFB }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x88 }, 
  {   69, 0x18 }, 
  {   70, 0x02 }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x88 }, 
  {   77, 0x00 }, 
  {   78, 0x02 }, 
  {   79, 0x00 }, 
  {   80, 0x30 }, 
  {   81, 0x55 }, 
  {   82, 0x44 }, 
  {   83, 0x00 }, 
  {   84, 0x3D }, 
  {   85, 0xBF }, 
  {   86, 0xFB }, 
  {   87, 0x00 }, 
  {   88, 0x00 }, 
  {   89, 0x00 }, 
  {   90, 0x00 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x20 }, 
  {   97, 0x05 }, 
  {   98, 0x43 }, 
  {   99, 0x00 }, 
  {  100, 0x30 }, 
  {  101, 0x5D }, 
  {  102, 0x43 }, 
  {  103, 0x00 }, 
  {  104, 0x35 }, 
  {  105, 0xE3 }, 
  {  106, 0xFB }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x88 }, 
  {  113, 0x18 }, 
  {  114, 0x01 }, 
  {  115, 0x00 }, 
  {  116, 0x88 }, 
  {  117, 0x00 }, 
  {  118, 0x01 }, 
  {  119, 0x00 }, 
  {  120, 0x35 }, 
  {  121, 0xE7 }, 
  {  122, 0xFB }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xB3 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x45 }, 
  {   13, 0xE8 }, 
  {   14, 0x02 }, 
  {   15, 0x00 }, 
  {   16, 0x20 }, 
  {   17, 0x01 }, 
  {   18, 0x53 }, 
  {   19, 0x00 }, 
  {   20, 0x30 }, 
  {   21, 0x5D }, 
  {   22, 0x43 }, 
  {   23, 0x00 }, 
  {   24, 0x30 }, 
  {   25, 0x53 }, 
  {   26, 0xFB }, 
  {   27, 0x00 }, 
  {   28, 0x00 }, 
  {   29, 0x00 }, 
  {   30, 0x00 }, 
  {   31, 0x00 }, 
  {   32, 0x88 }, 
  {   33, 0x18 }, 
  {   34, 0x01 }, 
  {   35, 0x00 }, 
  {   36, 0x88 }, 
  {   37, 0x00 }, 
  {   38, 0x01 }, 
  {   39, 0x00 }, 
  {   40, 0x20 }, 
  {   41, 0x01 }, 
  {   42, 0x43 }, 
  {   43, 0x00 }, 
  {   44, 0x30 }, 
  {   45, 0x51 }, 
  {   46, 0x53 }, 
  {   47, 0x00 }, 
  {   48, 0x38 }, 
  {   49, 0x5F }, 
  {   50, 0xFB }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x45 }, 
  {   61, 0xEC }, 
  {   62, 0x02 }, 
  {   63, 0x00 }, 
  {   64, 0x35 }, 
  {   65, 0xE9 }, 
  {   66, 0x2F }, 
  {   67, 0x00 }, 
  {   68, 0x3D }, 
  {   69, 0xED }, 
  {   70, 0x4D }, 
  {   71, 0x00 }, 
  {   72, 0x35 }, 
  {   73, 0xE9 }, 
  {   74, 0x2D }, 
  {   75, 0x00 }, 
  {   76, 0x3D }, 
  {   77, 0xED }, 
  {   78, 0x4C }, 
  {   79, 0x00 }, 
  {   80, 0x20 }, 
  {   81, 0x01 }, 
  {   82, 0x2E }, 
  {   83, 0x00 }, 
  {   84, 0x30 }, 
  {   85, 0x55 }, 
  {   86, 0x2E }, 
  {   87, 0x00 }, 
  {   88, 0x20 }, 
  {   89, 0x01 }, 
  {   90, 0x2C }, 
  {   91, 0x00 }, 
  {   92, 0x46 }, 
  {   93, 0x14 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x46 }, 
  {   97, 0x18 }, 
  {   98, 0x01 }, 
  {   99, 0x00 }, 
  {  100, 0x36 }, 
  {  101, 0x14 }, 
  {  102, 0x16 }, 
  {  103, 0x00 }, 
  {  104, 0x36 }, 
  {  105, 0x19 }, 
  {  106, 0x18 }, 
  {  107, 0x00 }, 
  {  108, 0x00 }, 
  {  109, 0x00 }, 
  {  110, 0x00 }, 
  {  111, 0x00 }, 
  {  112, 0x20 }, 
  {  113, 0x00 }, 
  {  114, 0x16 }, 
  {  115, 0x00 }, 
  {  116, 0x20 }, 
  {  117, 0x01 }, 
  {  118, 0x45 }, 
  {  119, 0x00 }, 
  {  120, 0x20 }, 
  {  121, 0x01 }, 
  {  122, 0x49 }, 
  {  123, 0x00 }, 
  {  124, 0x35 }, 
  {  125, 0xD1 }, 
  {  126, 0x31 }, 
  {  127, 0x00 }, 
  {    0, 0xB4 }, 
  {    8, 0x6D }, 
  {    9, 0xD5 }, 
  {   10, 0x45 }, 
  {   11, 0x00 }, 
  {   12, 0x80 }, 
  {   13, 0x51 }, 
  {   14, 0x33 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x20 }, 
  {   21, 0x01 }, 
  {   22, 0x30 }, 
  {   23, 0x00 }, 
  {   24, 0x00 }, 
  {   25, 0x00 }, 
  {   26, 0x00 }, 
  {   27, 0x00 }, 
  {   28, 0x88 }, 
  {   29, 0x10 }, 
  {   30, 0x02 }, 
  {   31, 0x00 }, 
  {   32, 0x30 }, 
  {   33, 0x55 }, 
  {   34, 0x30 }, 
  {   35, 0x00 }, 
  {   36, 0x88 }, 
  {   37, 0x00 }, 
  {   38, 0x02 }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x55 }, 
  {   42, 0x33 }, 
  {   43, 0x00 }, 
  {   44, 0x00 }, 
  {   45, 0x00 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x20 }, 
  {   53, 0x05 }, 
  {   54, 0x32 }, 
  {   55, 0x00 }, 
  {   56, 0x30 }, 
  {   57, 0x01 }, 
  {   58, 0x32 }, 
  {   59, 0x00 }, 
  {   60, 0x68 }, 
  {   61, 0x5D }, 
  {   62, 0x45 }, 
  {   63, 0x00 }, 
  {   64, 0x30 }, 
  {   65, 0x5D }, 
  {   66, 0x45 }, 
  {   67, 0x00 }, 
  {   68, 0x00 }, 
  {   69, 0x00 }, 
  {   70, 0x00 }, 
  {   71, 0x00 }, 
  {   72, 0x20 }, 
  {   73, 0x01 }, 
  {   74, 0x46 }, 
  {   75, 0x00 }, 
  {   76, 0x88 }, 
  {   77, 0x18 }, 
  {   78, 0x02 }, 
  {   79, 0x00 }, 
  {   80, 0x30 }, 
  {   81, 0x5D }, 
  {   82, 0x46 }, 
  {   83, 0x00 }, 
  {   84, 0x88 }, 
  {   85, 0x00 }, 
  {   86, 0x02 }, 
  {   87, 0x00 }, 
  {   88, 0x30 }, 
  {   89, 0x51 }, 
  {   90, 0x46 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0x5D }, 
  {   98, 0x46 }, 
  {   99, 0x00 }, 
  {  100, 0x20 }, 
  {  101, 0x01 }, 
  {  102, 0x45 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x88 }, 
  {  109, 0x14 }, 
  {  110, 0x02 }, 
  {  111, 0x00 }, 
  {  112, 0x30 }, 
  {  113, 0x5B }, 
  {  114, 0xFB }, 
  {  115, 0x00 }, 
  {  116, 0x88 }, 
  {  117, 0x00 }, 
  {  118, 0x02 }, 
  {  119, 0x00 }, 
  {  120, 0x30 }, 
  {  121, 0x55 }, 
  {  122, 0x45 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xB5 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x20 }, 
  {   13, 0x05 }, 
  {   14, 0x45 }, 
  {   15, 0x00 }, 
  {   16, 0x30 }, 
  {   17, 0x5D }, 
  {   18, 0x3D }, 
  {   19, 0x00 }, 
  {   20, 0x80 }, 
  {   21, 0x5B }, 
  {   22, 0xFB }, 
  {   23, 0x00 }, 
  {   24, 0x30 }, 
  {   25, 0x55 }, 
  {   26, 0x31 }, 
  {   27, 0x00 }, 
  {   28, 0x30 }, 
  {   29, 0x55 }, 
  {   30, 0x33 }, 
  {   31, 0x00 }, 
  {   32, 0x88 }, 
  {   33, 0x0C }, 
  {   34, 0x04 }, 
  {   35, 0x00 }, 
  {   36, 0x20 }, 
  {   37, 0x05 }, 
  {   38, 0x30 }, 
  {   39, 0x00 }, 
  {   40, 0x30 }, 
  {   41, 0x55 }, 
  {   42, 0x49 }, 
  {   43, 0x00 }, 
  {   44, 0x20 }, 
  {   45, 0x05 }, 
  {   46, 0x32 }, 
  {   47, 0x00 }, 
  {   48, 0x88 }, 
  {   49, 0x00 }, 
  {   50, 0x04 }, 
  {   51, 0x00 }, 
  {   52, 0x30 }, 
  {   53, 0x55 }, 
  {   54, 0x45 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   67, 0x00 }, 
  {   68, 0x20 }, 
  {   69, 0x05 }, 
  {   70, 0x45 }, 
  {   71, 0x00 }, 
  {   72, 0x30 }, 
  {   73, 0x5D }, 
  {   74, 0x3B }, 
  {   75, 0x00 }, 
  {   76, 0x80 }, 
  {   77, 0x5B }, 
  {   78, 0xFB }, 
  {   79, 0x00 }, 
  {   80, 0x30 }, 
  {   81, 0x55 }, 
  {   82, 0x31 }, 
  {   83, 0x00 }, 
  {   84, 0x30 }, 
  {   85, 0x55 }, 
  {   86, 0x33 }, 
  {   87, 0x00 }, 
  {   88, 0x88 }, 
  {   89, 0x10 }, 
  {   90, 0x04 }, 
  {   91, 0x00 }, 
  {   92, 0x20 }, 
  {   93, 0x05 }, 
  {   94, 0x30 }, 
  {   95, 0x00 }, 
  {   96, 0x30 }, 
  {   97, 0x55 }, 
  {   98, 0x49 }, 
  {   99, 0x00 }, 
  {  100, 0x20 }, 
  {  101, 0x05 }, 
  {  102, 0x32 }, 
  {  103, 0x00 }, 
  {  104, 0x88 }, 
  {  105, 0x00 }, 
  {  106, 0x04 }, 
  {  107, 0x00 }, 
  {  108, 0x30 }, 
  {  109, 0x55 }, 
  {  110, 0x45 }, 
  {  111, 0x00 }, 
  {  112, 0x00 }, 
  {  113, 0x00 }, 
  {  114, 0x00 }, 
  {  115, 0x00 }, 
  {  116, 0x00 }, 
  {  117, 0x00 }, 
  {  118, 0x00 }, 
  {  119, 0x00 }, 
  {  120, 0x00 }, 
  {  121, 0x00 }, 
  {  122, 0x00 }, 
  {  123, 0x00 }, 
  {  124, 0x20 }, 
  {  125, 0xFD }, 
  {  126, 0x45 }, 
  {  127, 0x00 }, 
  {    0, 0xB6 }, 
  {    8, 0x36 }, 
  {    9, 0x14 }, 
  {   10, 0x07 }, 
  {   11, 0x00 }, 
  {   12, 0x00 }, 
  {   13, 0x00 }, 
  {   14, 0x00 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x20 }, 
  {   21, 0x01 }, 
  {   22, 0x16 }, 
  {   23, 0x00 }, 
  {   24, 0x10 }, 
  {   25, 0x01 }, 
  {   26, 0x7E }, 
  {   27, 0x00 }, 
  {   28, 0x10 }, 
  {   29, 0x05 }, 
  {   30, 0x7E }, 
  {   31, 0x00 }, 
  {   32, 0x30 }, 
  {   33, 0x55 }, 
  {   34, 0x45 }, 
  {   35, 0x00 }, 
  {   36, 0x00 }, 
  {   37, 0x00 }, 
  {   38, 0x00 }, 
  {   39, 0x00 }, 
  {   40, 0x00 }, 
  {   41, 0x00 }, 
  {   42, 0x00 }, 
  {   43, 0x00 }, 
  {   44, 0x20 }, 
  {   45, 0x04 }, 
  {   46, 0x00 }, 
  {   47, 0x00 }, 
  {   48, 0x37 }, 
  {   49, 0x0F }, 
  {   50, 0xFB }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x38 }, 
  {   57, 0x4F }, 
  {   58, 0xFB }, 
  {   59, 0x00 }, 
  {   60, 0x88 }, 
  {   61, 0x17 }, 
  {   62, 0xFE }, 
  {   63, 0x00 }, 
  {   64, 0x10 }, 
  {   65, 0x01 }, 
  {   66, 0x7D }, 
  {   67, 0x00 }, 
  {   68, 0x10 }, 
  {   69, 0x05 }, 
  {   70, 0x7D }, 
  {   71, 0x00 }, 
  {   72, 0x37 }, 
  {   73, 0x13 }, 
  {   74, 0xFB }, 
}; // first_reg_value miniDSP_D_first_reg_values_p8
first_reg_value miniDSP_D_first_reg_values_p9[] = {
  {   75, 0x00 }, 
  {   76, 0x00 }, 
  {   77, 0x00 }, 
  {   78, 0x00 }, 
  {   79, 0x00 }, 
  {   80, 0x38 }, 
  {   81, 0x4F }, 
  {   82, 0xFB }, 
  {   83, 0x00 }, 
  {   84, 0x88 }, 
  {   85, 0x17 }, 
  {   86, 0xFE }, 
  {   87, 0x00 }, 
  {   88, 0x36 }, 
  {   89, 0x61 }, 
  {   90, 0x16 }, 
  {   91, 0x00 }, 
  {   92, 0x00 }, 
  {   93, 0x00 }, 
  {   94, 0x00 }, 
  {   95, 0x00 }, 
  {   96, 0x4E }, 
  {   97, 0x60 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x00 }, 
  {  101, 0x00 }, 
  {  102, 0x00 }, 
  {  103, 0x00 }, 
  {  104, 0x00 }, 
  {  105, 0x00 }, 
  {  106, 0x00 }, 
  {  107, 0x00 }, 
  {  108, 0x28 }, 
  {  109, 0x01 }, 
  {  110, 0x55 }, 
  {  111, 0x00 }, 
  {  112, 0x36 }, 
  {  113, 0x69 }, 
  {  114, 0x56 }, 
  {  115, 0x00 }, 
  {  116, 0x3E }, 
  {  117, 0x6D }, 
  {  118, 0x57 }, 
  {  119, 0x00 }, 
  {  120, 0x3E }, 
  {  121, 0x65 }, 
  {  122, 0x55 }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xB7 }, 
  {    8, 0x36 }, 
  {    9, 0x71 }, 
  {   10, 0x75 }, 
  {   11, 0x00 }, 
  {   12, 0xA6 }, 
  {   13, 0x71 }, 
  {   14, 0x56 }, 
  {   15, 0x00 }, 
  {   16, 0x3E }, 
  {   17, 0x75 }, 
  {   18, 0x73 }, 
  {   19, 0x00 }, 
  {   20, 0x3E }, 
  {   21, 0x75 }, 
  {   22, 0x58 }, 
  {   23, 0x00 }, 
  {   24, 0x3E }, 
  {   25, 0x79 }, 
  {   26, 0x6F }, 
  {   27, 0x00 }, 
  {   28, 0x3E }, 
  {   29, 0x79 }, 
  {   30, 0x5C }, 
  {   31, 0x00 }, 
  {   32, 0x3E }, 
  {   33, 0x7D }, 
  {   34, 0x71 }, 
  {   35, 0x00 }, 
  {   36, 0x3E }, 
  {   37, 0x7D }, 
  {   38, 0x5A }, 
  {   39, 0x00 }, 
  {   40, 0x3E }, 
  {   41, 0x81 }, 
  {   42, 0x6B }, 
  {   43, 0x00 }, 
  {   44, 0x3E }, 
  {   45, 0x81 }, 
  {   46, 0x60 }, 
  {   47, 0x00 }, 
  {   48, 0x3E }, 
  {   49, 0x85 }, 
  {   50, 0x6D }, 
  {   51, 0x00 }, 
  {   52, 0x3E }, 
  {   53, 0x85 }, 
  {   54, 0x5E }, 
  {   55, 0x00 }, 
  {   56, 0x3E }, 
  {   57, 0x89 }, 
  {   58, 0x69 }, 
  {   59, 0x00 }, 
  {   60, 0x3E }, 
  {   61, 0x89 }, 
  {   62, 0x62 }, 
  {   63, 0x00 }, 
  {   64, 0x3E }, 
  {   65, 0x8D }, 
  {   66, 0x67 }, 
  {   67, 0x00 }, 
  {   68, 0x3E }, 
  {   69, 0x8D }, 
  {   70, 0x64 }, 
  {   71, 0x00 }, 
  {   72, 0x3E }, 
  {   73, 0x91 }, 
  {   74, 0x66 }, 
  {   75, 0x00 }, 
  {   76, 0x3E }, 
  {   77, 0x91 }, 
  {   78, 0x65 }, 
  {   79, 0x00 }, 
  {   80, 0x3E }, 
  {   81, 0x95 }, 
  {   82, 0x74 }, 
  {   83, 0x00 }, 
  {   84, 0x3E }, 
  {   85, 0x95 }, 
  {   86, 0x57 }, 
  {   87, 0x00 }, 
  {   88, 0x3E }, 
  {   89, 0x99 }, 
  {   90, 0x6C }, 
  {   91, 0x00 }, 
  {   92, 0x3E }, 
  {   93, 0x99 }, 
  {   94, 0x5F }, 
  {   95, 0x00 }, 
  {   96, 0x3E }, 
  {   97, 0x9D }, 
  {   98, 0x70 }, 
  {   99, 0x00 }, 
  {  100, 0x3E }, 
  {  101, 0x9D }, 
  {  102, 0x5B }, 
  {  103, 0x00 }, 
  {  104, 0x3E }, 
  {  105, 0xA1 }, 
  {  106, 0x72 }, 
  {  107, 0x00 }, 
  {  108, 0x3E }, 
  {  109, 0xA1 }, 
  {  110, 0x59 }, 
  {  111, 0x00 }, 
  {  112, 0x3E }, 
  {  113, 0xA5 }, 
  {  114, 0x6E }, 
  {  115, 0x00 }, 
  {  116, 0x3E }, 
  {  117, 0xA5 }, 
  {  118, 0x5D }, 
  {  119, 0x00 }, 
  {  120, 0x3E }, 
  {  121, 0xA9 }, 
  {  122, 0x6A }, 
  {  123, 0x00 }, 
  {  124, 0x3E }, 
  {  125, 0xA9 }, 
  {  126, 0x61 }, 
  {  127, 0x00 }, 
  {    0, 0xB8 }, 
  {    8, 0x3E }, 
  {    9, 0xAD }, 
  {   10, 0x68 }, 
  {   11, 0x00 }, 
  {   12, 0x3E }, 
  {   13, 0xAD }, 
  {   14, 0x63 }, 
  {   15, 0x00 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x00 }, 
  {   19, 0x00 }, 
  {   20, 0x36 }, 
  {   21, 0xB5 }, 
  {   22, 0x7B }, 
  {   23, 0x00 }, 
  {   24, 0x9E }, 
  {   25, 0xB9 }, 
  {   26, 0x79 }, 
  {   27, 0x00 }, 
  {   28, 0x3E }, 
  {   29, 0xBD }, 
  {   30, 0x7C }, 
  {   31, 0x00 }, 
  {   32, 0x3E }, 
  {   33, 0xC1 }, 
  {   34, 0x77 }, 
  {   35, 0x00 }, 
  {   36, 0x3E }, 
  {   37, 0xC5 }, 
  {   38, 0x7A }, 
  {   39, 0x00 }, 
  {   40, 0x3E }, 
  {   41, 0xC9 }, 
  {   42, 0x76 }, 
  {   43, 0x00 }, 
  {   44, 0x3E }, 
  {   45, 0xCD }, 
  {   46, 0x78 }, 
  {   47, 0x00 }, 
  {   48, 0x00 }, 
  {   49, 0x00 }, 
  {   50, 0x00 }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x36 }, 
  {   57, 0xB5 }, 
  {   58, 0x7A }, 
  {   59, 0x00 }, 
  {   60, 0x3E }, 
  {   61, 0xB9 }, 
  {   62, 0x7C }, 
  {   63, 0x00 }, 
  {   64, 0x20 }, 
  {   65, 0x11 }, 
  {   66, 0x7F }, 
  {   67, 0x00 }, 
  {   68, 0x3E }, 
  {   69, 0xBD }, 
  {   70, 0x79 }, 
  {   71, 0x00 }, 
  {   72, 0x3E }, 
  {   73, 0xC1 }, 
  {   74, 0x77 }, 
  {   75, 0x00 }, 
  {   76, 0x3E }, 
  {   77, 0xC5 }, 
  {   78, 0x7B }, 
  {   79, 0x00 }, 
  {   80, 0x3E }, 
  {   81, 0xC9 }, 
  {   82, 0x78 }, 
  {   83, 0x00 }, 
  {   84, 0x3E }, 
  {   85, 0xCD }, 
  {   86, 0x76 }, 
  {   87, 0x00 }, 
  {   88, 0x36 }, 
  {   89, 0xB1 }, 
  {   90, 0x65 }, 
  {   91, 0x00 }, 
  {   92, 0x36 }, 
  {   93, 0xB5 }, 
  {   94, 0x77 }, 
  {   95, 0x00 }, 
  {   96, 0x20 }, 
  {   97, 0x11 }, 
  {   98, 0x7E }, 
  {   99, 0x00 }, 
  {  100, 0x9E }, 
  {  101, 0xB9 }, 
  {  102, 0x75 }, 
  {  103, 0x00 }, 
  {  104, 0x3E }, 
  {  105, 0xBD }, 
  {  106, 0x78 }, 
  {  107, 0x00 }, 
  {  108, 0x3E }, 
  {  109, 0xC1 }, 
  {  110, 0x7A }, 
  {  111, 0x00 }, 
  {  112, 0x3E }, 
  {  113, 0xC5 }, 
  {  114, 0x76 }, 
  {  115, 0x00 }, 
  {  116, 0x3E }, 
  {  117, 0xC9 }, 
  {  118, 0x79 }, 
  {  119, 0x00 }, 
  {  120, 0x3E }, 
  {  121, 0xCD }, 
  {  122, 0x7B }, 
  {  123, 0x00 }, 
  {  124, 0x00 }, 
  {  125, 0x00 }, 
  {  126, 0x00 }, 
  {  127, 0x00 }, 
  {    0, 0xB9 }, 
  {    8, 0x00 }, 
  {    9, 0x00 }, 
  {   10, 0x00 }, 
  {   11, 0x00 }, 
  {   12, 0x36 }, 
  {   13, 0xB5 }, 
  {   14, 0x76 }, 
  {   15, 0x00 }, 
  {   16, 0x3E }, 
  {   17, 0xB9 }, 
  {   18, 0x78 }, 
  {   19, 0x00 }, 
  {   20, 0x20 }, 
  {   21, 0x11 }, 
  {   22, 0x7D }, 
  {   23, 0x00 }, 
  {   24, 0x3E }, 
  {   25, 0xBD }, 
  {   26, 0x75 }, 
  {   27, 0x00 }, 
  {   28, 0x3E }, 
  {   29, 0xC1 }, 
  {   30, 0x7A }, 
  {   31, 0x00 }, 
  {   32, 0x3E }, 
  {   33, 0xC5 }, 
  {   34, 0x77 }, 
  {   35, 0x00 }, 
  {   36, 0x3E }, 
  {   37, 0xC9 }, 
  {   38, 0x7B }, 
  {   39, 0x00 }, 
  {   40, 0x3E }, 
  {   41, 0xCD }, 
  {   42, 0x79 }, 
  {   43, 0x00 }, 
  {   44, 0x10 }, 
  {   45, 0x01 }, 
  {   46, 0x7F }, 
  {   47, 0x00 }, 
  {   48, 0x10 }, 
  {   49, 0x05 }, 
  {   50, 0x7F }, 
  {   51, 0x00 }, 
  {   52, 0x00 }, 
  {   53, 0x00 }, 
  {   54, 0x00 }, 
  {   55, 0x00 }, 
  {   56, 0x00 }, 
  {   57, 0x00 }, 
  {   58, 0x00 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {   61, 0x00 }, 
  {   62, 0x00 }, 
  {   63, 0x00 }, 
  {   64, 0x20 }, 
  {   65, 0x11 }, 
  {   66, 0x7C }, 
  {   67, 0x00 }, 
  {   68, 0x37 }, 
  {   69, 0x17 }, 
  {   70, 0xFB }, 
  {   71, 0x00 }, 
  {   72, 0x00 }, 
  {   73, 0x00 }, 
  {   74, 0x00 }, 
  {   75, 0x00 }, 
  {   76, 0x38 }, 
  {   77, 0x4F }, 
  {   78, 0xFB }, 
  {   79, 0x00 }, 
  {   80, 0x88 }, 
  {   81, 0x17 }, 
  {   82, 0xFE }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {   85, 0x00 }, 
  {   86, 0x00 }, 
  {   87, 0x00 }, 
  {   88, 0x10 }, 
  {   89, 0x08 }, 
  {   90, 0x04 }, 
  {   91, 0x00 }, 
  {   92, 0x10 }, 
  {   93, 0x0C }, 
  {   94, 0x01 }, 
  {   95, 0x00 }, 
  {   96, 0x00 }, 
  {   97, 0x00 }, 
  {   98, 0x00 }, 
  {   99, 0x00 }, 
  {  100, 0x88 }, 
  {  101, 0x03 }, 
  {  102, 0xFF }, 
  {  103, 0x00 }, 
  {    0, 0x01 }, 
  {    1, 0x08 }, 
  {    2, 0x00 }, 
  {    0, 0x00 }, 
  {   60, 0x00 }, 
  {    4, 0x03 }, 
  {    5, 0x91 }, 
  {    6, 0x04 }, 
  {    7, 0x03 }, 
  {    8, 0xC0 }, 
  {   11, 0x82 }, 
  {   12, 0x88 }, 
  {   13, 0x03 }, 
  {   14, 0x00 }, 
  {   18, 0x88 }, 
  {   19, 0x8C }, 
  {   20, 0x80 }, 
  {   29, 0x01 }, 
  {   30, 0x82 }, 
  {   23, 0x04 }, 
  {   17, 0x04 }, 
  {   27, 0x2C }, 
  {   63, 0xD6 }, 
  {   55, 0x0E }, 
  {   81, 0xDC }, 
  {   82, 0x00 }, 
  {   83, 0x00 }, 
  {   84, 0x00 }, 
  {    0, 0x01 }, 
  {   51, 0x68 }, 
  {   52, 0x04 }, 
  {   54, 0x40 }, 
  {   55, 0x04 }, 
  {   57, 0x40 }, 
  {   59, 0x3C }, 
  {   60, 0x3C }, 
  {   71, 0x30 }, 
  {   20, 0x35 }, 
  {   12, 0x08 }, 
  {   13, 0x08 }, 
  {    0, 0x00 }, 
  {   64, 0x00 }, 
  {    0, 0x01 }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {    9, 0x30 }, 
  {    0, 0x00 }, 
  {   68, 0x0F }, 
  {    0, 0x08 }, 
  {    1, 0x04 }, 
  {    0, 0x00 }, 
  {    9, 0x00 }, 
  {    0, 0x01 }, 
  {   63, 0x14 }, 
  {   64, 0x0C }, 
  {   81, 0x00 }, 
  {    2, 0xA9 }, 
  {    1, 0x08 }, 
  {    2, 0xA1 }, 
  {   71, 0x32 }, 
  {  123, 0x01 }, 
  {   52, 0x10 }, 
  {   54, 0x40 }, 
  {   55, 0x10 }, 
  {   57, 0x40 }, 
  {   59, 0x00 }, 
  {   60, 0x00 }, 
  {    0, 0x00 }, 
  {   55, 0x0E }, 
  {   81, 0xDC }, 
  {   82, 0x00 }, 
  {    0, 0x01 }, 
  {   10, 0x08 }, 
  {   20, 0x35 }, 
  {   12, 0x08 }, 
  {   13, 0x08 }, 
  {   14, 0x08 }, 
  {   15, 0x08 }, 
  {    9, 0x3C }, 
  {   16, 0x00 }, 
  {   17, 0x00 }, 
  {   18, 0x14 }, 
  {   19, 0x14 }, 
  {    0, 0x00 }, 
  {   65, 0x00 }, 
  {   66, 0x00 }, 
  {   63, 0xD6 }, 
  {   64, 0x00 }, 
}; // first_reg_value miniDSP_D_first_reg_values_p9
